/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.ui.tools.api.views.common.item.CommonSessionItem;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ControlledRoot;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ResourcesFolderItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ViewpointsFolderItemImpl;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class SessionWrapperContentProvider
implements ITreeContentProvider {
    private ITreeContentProvider wrapped;
    private Collection<ITreeContentProvider> extensions;

    public SessionWrapperContentProvider(ITreeContentProvider wrapped) {
        this.wrapped = wrapped;
    }

    public void setExtensions(Collection<ITreeContentProvider> extensions) {
        this.extensions = extensions;
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList allChildren = Lists.newArrayList();
        try {
            allChildren.addAll(this.doGetChildren(parentElement));
            allChildren.addAll(this.getChildrenFromExtensions(parentElement));
        }
        catch (IllegalStateException illegalStateException) {}
        return allChildren.toArray();
    }

    public Collection<Object> getChildrenFromExtensions(Object parentElement) {
        ArrayList extensionsChildren = Lists.newArrayList();
        if (this.extensions != null) {
            for (ITreeContentProvider extension : this.extensions) {
                extensionsChildren.addAll(Arrays.asList(extension.getChildren(parentElement)));
            }
        }
        return extensionsChildren;
    }

    private Collection<Object> doGetChildren(Object parentElement) {
        ArrayList result = Lists.newArrayList();
        if (parentElement instanceof Session) {
            result.addAll(this.getSessionChildren((Session)parentElement));
        } else if (parentElement instanceof CommonSessionItem) {
            result.addAll(((CommonSessionItem)parentElement).getChildren());
        } else if (parentElement instanceof Collection) {
            result.addAll((Collection)parentElement);
        } else if (parentElement instanceof Resource) {
            Resource res = (Resource)parentElement;
            Session session = SessionManager.INSTANCE.getSession(res);
            if (res.isLoaded()) {
                if (session instanceof DAnalysisSessionEObject && ((DAnalysisSessionEObject)session).getControlledResources().contains(parentElement)) {
                    for (EObject obj : res.getContents()) {
                        result.add(new ControlledRoot(obj, parentElement));
                    }
                } else {
                    result.addAll(this.getWrappedChildren(parentElement));
                }
            }
        } else if (parentElement instanceof EObject && !(parentElement instanceof DRepresentationDescriptor)) {
            result.addAll(this.getWrappedChildren(parentElement));
            result.addAll(this.getRepresentationDescriptorsAssociatedToEObject((EObject)parentElement));
        }
        return result;
    }

    private Collection<Object> getWrappedChildren(Object parentElement) {
        Object[] structuralChildren = this.wrapped.getChildren(parentElement);
        if (structuralChildren != null) {
            return Arrays.asList(structuralChildren);
        }
        return Collections.emptyList();
    }

    private Collection<Object> getSessionChildren(Session session) {
        ArrayList all = Lists.newArrayList();
        if (session instanceof DAnalysisSession && !session.getReferencedSessionResources().isEmpty()) {
            all.add(new ResourcesFolderItemImpl(session, session));
        }
        all.add(new ViewpointsFolderItemImpl(session, session));
        all.addAll(this.getSemanticResources(session));
        return all;
    }

    private Collection<Resource> getSemanticResources(Session session) {
        ArrayList allSemanticRes = Lists.newArrayList();
        allSemanticRes.addAll(session.getSemanticResources());
        if (session instanceof DAnalysisSessionEObject) {
            allSemanticRes.addAll(((DAnalysisSessionEObject)session).getControlledResources());
        }
        return allSemanticRes;
    }

    private Collection<DRepresentationDescriptor> getRepresentationDescriptorsAssociatedToEObject(EObject eObject) {
        Session session = SessionManager.INSTANCE.getSession(eObject);
        if (session != null && session.isOpen()) {
            Collection allRepDescriptors = DialectManager.INSTANCE.getRepresentationDescriptors(eObject, session);
            ArrayList filteredReps = Lists.newArrayList((Iterable)Iterables.filter((Iterable)allRepDescriptors, (Predicate)new InViewpointPredicate(session.getSelectedViewpoints(false))));
            Collections.sort(filteredReps, Ordering.natural().onResultOf((Function)new Function<DRepresentationDescriptor, String>(){

                public String apply(DRepresentationDescriptor from) {
                    return from.getName();
                }
            }));
            return filteredReps;
        }
        return Collections.emptyList();
    }

    private Collection<Resource> filter(Collection<Resource> resources) {
        ArrayList<Resource> result = new ArrayList<Resource>(resources.size());
        for (Resource res : resources) {
            if (this.isFiltered(res)) continue;
            result.add(res);
        }
        return result;
    }

    private boolean isFiltered(Resource resource) {
        return new ResourceQuery(resource).isRepresentationsResource();
    }

    public Object getParent(Object element) {
        Object parent = this.getParentFromExtensions(element);
        if (parent == null) {
            if (element instanceof DRepresentationDescriptor) {
                parent = ((DRepresentationDescriptor)element).getTarget();
            } else if (element instanceof Resource) {
                parent = SessionManager.INSTANCE.getSession((Resource)element);
            } else if (element instanceof CommonSessionItem) {
                parent = ((CommonSessionItem)element).getParent();
            } else if (element instanceof EObject) {
                parent = this.wrapped.getParent(element);
            }
        }
        return parent;
    }

    public Object getParentFromExtensions(Object element) {
        if (this.extensions != null) {
            for (ITreeContentProvider extension : this.extensions) {
                Object parent = extension.getParent(element);
                if (parent == null) continue;
                return parent;
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length != 0;
    }

    public Object[] getElements(Object inputElement) {
        Object[] result = null;
        if (inputElement instanceof Session) {
            result = this.filter(((Session)inputElement).getSemanticResources()).toArray();
        }
        if (inputElement instanceof Collection) {
            result = ((Collection)inputElement).toArray();
        }
        if (result == null) {
            return this.wrapped.getElements(inputElement);
        }
        return result;
    }

    public void dispose() {
        try {
            this.wrapped.dispose();
            if (this.wrapped instanceof AdapterFactoryContentProvider && ((AdapterFactoryContentProvider)this.wrapped).getAdapterFactory() instanceof IDisposable) {
                ((IDisposable)((AdapterFactoryContentProvider)this.wrapped).getAdapterFactory()).dispose();
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.wrapped != null) {
            this.wrapped.inputChanged(viewer, oldInput, newInput);
        }
    }

    private static class InViewpointPredicate
    implements Predicate<DRepresentationDescriptor> {
        private final Collection<Viewpoint> scope;

        public InViewpointPredicate(Collection<Viewpoint> scope) {
            this.scope = scope;
        }

        public boolean apply(DRepresentationDescriptor repDescriptor) {
            Viewpoint reprViewpoint;
            RepresentationDescription description;
            if (repDescriptor.eResource() != null && (description = repDescriptor.getDescription()) != null && (reprViewpoint = new RepresentationDescriptionQuery(description).getParentViewpoint()) != null && !reprViewpoint.eIsProxy() && reprViewpoint.eResource() != null) {
                for (Viewpoint viewpoint : this.scope) {
                    if (!EqualityHelper.areEquals((EObject)viewpoint, (EObject)reprViewpoint)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

