/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.session;

import java.lang.ref.WeakReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IMemento;

public class SessionEditorInput
extends URIEditorInput {
    private static final String SESSION_RESOURCE_URI = "SESSION_RESOURCE_URI";
    private WeakReference<Session> sessionRef;
    private String name;
    private URI sessionResourceURI;
    private WeakReference<EObject> inputRef;
    private IStatus status = Status.OK_STATUS;

    public SessionEditorInput(URI uri, String name, Session session) {
        super(uri, name);
        this.name = name;
        this.sessionRef = new WeakReference<Session>(session);
        if (session.getSessionResource() != null) {
            this.sessionResourceURI = session.getSessionResource().getURI();
        }
    }

    public SessionEditorInput(IMemento memento) {
        super(memento);
    }

    public Session getSession() {
        return this.getSession(true);
    }

    public Session getSession(boolean restore) {
        Session session;
        Session session2 = session = this.sessionRef != null ? (Session)this.sessionRef.get() : null;
        if (session == null || !session.isOpen() && !Messages.SessionEditorInput_defaultEditorName.equals(this.name)) {
            URI sessionModelURI = this.getURI().trimFragment();
            if (this.sessionResourceURI != null) {
                sessionModelURI = this.sessionResourceURI;
            }
            if ((session = this.getSession(sessionModelURI, restore)) != null) {
                this.sessionRef = new WeakReference<Session>(session);
            }
        }
        return session;
    }

    public EObject getInput() {
        return this.getInput(true);
    }

    private EObject getInput(boolean restore) {
        Session session;
        EObject input;
        EObject eObject = input = this.inputRef != null ? (EObject)this.inputRef.get() : null;
        if (input == null && (session = this.getSession(restore)) != null && session.isOpen() && this.getURI().hasFragment() && (input = session.getTransactionalEditingDomain().getResourceSet().getEObject(this.getURI(), false)) != null) {
            this.inputRef = new WeakReference<EObject>(input);
        }
        return input;
    }

    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("uri", this.getURI().toString());
        memento.putString("name", this.getName());
        memento.putString("class", ((Object)((Object)this)).getClass().getName());
        if (this.sessionResourceURI != null) {
            memento.putString(SESSION_RESOURCE_URI, this.sessionResourceURI.toString());
        }
    }

    protected void loadState(IMemento memento) {
        super.loadState(memento);
        this.setName(memento.getString("name"));
        String sessionResourceURIString = memento.getString(SESSION_RESOURCE_URI);
        if (sessionResourceURIString != null) {
            this.sessionResourceURI = URI.createURI((String)sessionResourceURIString);
            Session newSession = this.getSession(this.sessionResourceURI);
            if (newSession != null) {
                this.sessionRef = new WeakReference<Session>(newSession);
            }
        }
    }

    protected Session getSession(URI sessionModelURI) {
        return this.getSession(sessionModelURI, true);
    }

    private Session getSession(URI sessionModelURI, boolean restore) {
        Session sessionFromURI;
        try {
            sessionFromURI = SessionManager.INSTANCE.getExistingSession(sessionModelURI);
            if (sessionFromURI == null && restore) {
                this.status = Status.OK_STATUS;
                sessionFromURI = SessionManager.INSTANCE.openSession(sessionModelURI, (IProgressMonitor)new NullProgressMonitor(), SiriusEditPlugin.getPlugin().getUiCallback());
            }
            if (sessionFromURI != null && sessionFromURI.isOpen()) {
                IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(sessionFromURI);
                if (uiSession == null && restore) {
                    uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(sessionFromURI);
                }
                if (uiSession != null && !uiSession.isOpen()) {
                    uiSession.open();
                }
            }
        }
        catch (OperationCanceledException e) {
            sessionFromURI = null;
            this.status = new Status(8, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            sessionFromURI = null;
            this.status = new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e);
        }
        return sessionFromURI;
    }

    protected String getBundleSymbolicName() {
        return SiriusEditPlugin.getPlugin().getSymbolicName();
    }

    public String getFactoryId() {
        return "org.eclipse.sirius.ui.business.api.session.SessionEditorInputFactory";
    }

    public static SessionEditorInput create(URI sessionResourceURI) {
        Session session;
        try {
            session = SessionFactory.INSTANCE.createSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            return null;
        }
        return new SessionEditorInput(sessionResourceURI, Messages.SessionEditorInput_defaultEditorName, session);
    }

    public String getToolTipText() {
        return String.valueOf(this.getURI().trimFragment().toString()) + "/" + this.getName();
    }

    @Deprecated
    public void dispose() {
    }

    public URI getURI() {
        EObject input;
        EObject eObject = input = this.inputRef != null ? (EObject)this.inputRef.get() : null;
        if (input != null) {
            try {
                return EcoreUtil.getURI((EObject)input);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return super.getURI();
    }

    public boolean exists() {
        Resource resource;
        EObject input;
        boolean exists = super.exists();
        if (!exists && (input = this.getInput(false)) != null && !input.eIsProxy() && (resource = input.eResource()) != null && resource.getResourceSet() != null) {
            exists = resource.getResourceSet().getURIConverter().exists(resource.getURI(), null);
        }
        return exists;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public Object getAdapter(Class adapter) {
        Session inputSession;
        Object a = super.getAdapter(adapter);
        if (IFile.class == adapter && a == null && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (inputSession = this.getSession(false)) != null && inputSession.isOpen()) {
            a = URIEditorInput.EclipseUtil.getAdatper((Class)adapter, (URI)inputSession.getSessionResource().getURI());
        }
        return a;
    }

    public int hashCode() {
        EObject input = this.getInput(false);
        if (input != null) {
            return input.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        boolean equals;
        boolean bl = equals = this == o || o instanceof SessionEditorInput && this.getURI().equals(((SessionEditorInput)((Object)o)).getURI());
        if (equals && o instanceof SessionEditorInput) {
            SessionEditorInput otherSessionEditorInput = (SessionEditorInput)((Object)o);
            IStatus otherStatus = otherSessionEditorInput.getStatus();
            if (this.status != otherStatus) {
                equals = false;
            } else {
                EObject input = this.getInput(false);
                if (input != null) {
                    equals = input.equals(otherSessionEditorInput.getInput(false));
                }
            }
        }
        return equals;
    }
}

