/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator;

import eu.fbk.tools.editor.basetype.baseType.AddSubOperator;
import eu.fbk.tools.editor.basetype.baseType.BaseTypeFactory;
import eu.fbk.tools.editor.basetype.baseType.BooleanLiteral;
import eu.fbk.tools.editor.basetype.baseType.EqualityOperator;
import eu.fbk.tools.editor.basetype.baseType.ExtendedMulDivOperator;
import eu.fbk.tools.editor.basetype.baseType.IntegerLiteral;
import eu.fbk.tools.editor.basetype.baseType.LogicalAndOperator;
import eu.fbk.tools.editor.basetype.baseType.LogicalOperator;
import eu.fbk.tools.editor.basetype.baseType.LogicalOrOperator;
import eu.fbk.tools.editor.basetype.baseType.Operator;
import eu.fbk.tools.editor.basetype.baseType.RealLiteral;
import eu.fbk.tools.editor.basetype.baseType.RelationalOperator;
import eu.fbk.tools.editor.basetype.baseType.UnaryAlgebraicOperator;
import eu.fbk.tools.editor.basetype.baseType.UnaryLogicalOperator;
import eu.fbk.tools.editor.c.expression.expression.AdditiveExpression;
import eu.fbk.tools.editor.c.expression.expression.AllExpression;
import eu.fbk.tools.editor.c.expression.expression.AndExpression;
import eu.fbk.tools.editor.c.expression.expression.CastExpression;
import eu.fbk.tools.editor.c.expression.expression.DecimalLiteral;
import eu.fbk.tools.editor.c.expression.expression.ExclusiveOrExpression;
import eu.fbk.tools.editor.c.expression.expression.Expression;
import eu.fbk.tools.editor.c.expression.expression.FloatingPointLiteral;
import eu.fbk.tools.editor.c.expression.expression.Identifier;
import eu.fbk.tools.editor.c.expression.expression.InclusiveOrExpression;
import eu.fbk.tools.editor.c.expression.expression.MultiplicativeExpression;
import eu.fbk.tools.editor.c.expression.expression.ParsExpression;
import eu.fbk.tools.editor.c.expression.expression.PostfixExpression;
import eu.fbk.tools.editor.c.expression.expression.RelationalExpression;
import eu.fbk.tools.editor.c.expression.expression.ShiftExpression;
import eu.fbk.tools.editor.c.expression.expression.UnaryExpression;
import eu.fbk.tools.editor.nusmv.smv.AbsExpression;
import eu.fbk.tools.editor.nusmv.smv.AddSubExpression;
import eu.fbk.tools.editor.nusmv.smv.BoundedExpression;
import eu.fbk.tools.editor.nusmv.smv.ComplexIdentifier;
import eu.fbk.tools.editor.nusmv.smv.CountExpression;
import eu.fbk.tools.editor.nusmv.smv.EqualityExpression;
import eu.fbk.tools.editor.nusmv.smv.LogicalAndExpression;
import eu.fbk.tools.editor.nusmv.smv.LogicalOrExpression;
import eu.fbk.tools.editor.nusmv.smv.MaxExpression;
import eu.fbk.tools.editor.nusmv.smv.MinExpression;
import eu.fbk.tools.editor.nusmv.smv.MulDivExpression;
import eu.fbk.tools.editor.nusmv.smv.NextExpression;
import eu.fbk.tools.editor.nusmv.smv.SmvFactory;
import eu.fbk.tools.editor.nusmv.smv.UnaryAlgebraicExpression;
import eu.fbk.tools.editor.nusmv.smv.UnaryLogicalExpression;
import eu.fbk.tools.editor.nusmv.smv.UserFunctionExpression;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

public class CleanCExprToSmvExpr {
    private static final Logger logger = Logger.getLogger(CleanCExprToSmvExpr.class);
    protected EMap<Expression, eu.fbk.tools.editor.basetype.baseType.Expression> exprCache;
    protected final SmvFactory smvFactory = SmvFactory.eINSTANCE;
    protected final BaseTypeFactory baseTypeFactory = BaseTypeFactory.eINSTANCE;

    public CleanCExprToSmvExpr() {
        this.exprCache = new BasicEMap();
    }

    public eu.fbk.tools.editor.basetype.baseType.Expression convert(Expression cleanCExpr) throws Exception {
        return this.get(cleanCExpr);
    }

    protected void visit(Expression e) throws Exception {
        if (this.exprCache.containsKey((Object)e)) {
            return;
        }
        if (e instanceof eu.fbk.tools.editor.c.expression.expression.LogicalOrExpression) {
            this.visitLogicalOrExpression((eu.fbk.tools.editor.c.expression.expression.LogicalOrExpression)e);
        } else if (e instanceof eu.fbk.tools.editor.c.expression.expression.LogicalAndExpression) {
            this.visitLogicalAndExpression((eu.fbk.tools.editor.c.expression.expression.LogicalAndExpression)e);
        } else if (e instanceof InclusiveOrExpression) {
            this.visitInclusiveOrExpression((InclusiveOrExpression)e);
        } else if (e instanceof ExclusiveOrExpression) {
            this.visitExclusiveOrExpression((ExclusiveOrExpression)e);
        } else if (e instanceof AndExpression) {
            this.visitAndExpression((AndExpression)e);
        } else if (e instanceof eu.fbk.tools.editor.c.expression.expression.EqualityExpression) {
            this.visitEqualityExpression((eu.fbk.tools.editor.c.expression.expression.EqualityExpression)e);
        } else if (e instanceof RelationalExpression) {
            this.visitRelationalExpression((RelationalExpression)e);
        } else if (e instanceof ShiftExpression) {
            this.visitShiftExpression((ShiftExpression)e);
        } else if (e instanceof AdditiveExpression) {
            this.visitAdditiveExpression((AdditiveExpression)e);
        } else if (e instanceof MultiplicativeExpression) {
            this.visitMultiplicativeExpression((MultiplicativeExpression)e);
        } else if (e instanceof CastExpression) {
            this.visitCastExpression((CastExpression)e);
        } else if (e instanceof UnaryExpression) {
            this.visitUnaryExpression((UnaryExpression)e);
        } else if (e instanceof PostfixExpression) {
            this.visitPostfixExpression((PostfixExpression)e);
        } else if (e instanceof ParsExpression) {
            this.visitParsExpression((ParsExpression)e);
        } else if (e instanceof Identifier) {
            this.visitIdentifier((Identifier)e);
        } else if (e instanceof DecimalLiteral) {
            this.visitDecimalLiteral((DecimalLiteral)e);
        } else if (e instanceof FloatingPointLiteral) {
            this.visitFloatingPointLiteral((FloatingPointLiteral)e);
        } else if (e instanceof eu.fbk.tools.editor.c.expression.expression.BooleanLiteral) {
            this.visitBooleanLiteral((eu.fbk.tools.editor.c.expression.expression.BooleanLiteral)e);
        } else if (e instanceof AllExpression) {
            this.visitAllExpression((AllExpression)e);
        } else {
            throw new Exception("Unsupported CleanC Expressions: " + e.toString());
        }
    }

    protected eu.fbk.tools.editor.basetype.baseType.Expression get(Expression e) throws Exception {
        this.visit(e);
        return (eu.fbk.tools.editor.basetype.baseType.Expression)this.exprCache.get((Object)e);
    }

    protected void visitLogicalOrExpression(eu.fbk.tools.editor.c.expression.expression.LogicalOrExpression e) throws Exception {
        LogicalOrExpression res = this.smvFactory.createLogicalOrExpression();
        res.setLeft(this.get(e.getLeft()));
        res.setRight(this.get(e.getRight()));
        LogicalOrOperator op = this.baseTypeFactory.createLogicalOrOperator();
        op.setName("|");
        res.setOp((LogicalOperator)op);
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitLogicalAndExpression(eu.fbk.tools.editor.c.expression.expression.LogicalAndExpression e) throws Exception {
        LogicalAndExpression res = this.smvFactory.createLogicalAndExpression();
        res.setLeft(this.get(e.getLeft()));
        res.setRight(this.get(e.getRight()));
        LogicalAndOperator op = this.baseTypeFactory.createLogicalAndOperator();
        op.setName("&");
        res.setOp((LogicalOperator)op);
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitInclusiveOrExpression(InclusiveOrExpression e) throws Exception {
        LogicalOrExpression res = this.smvFactory.createLogicalOrExpression();
        res.setLeft(this.get(e.getLeft()));
        res.setRight(this.get(e.getRight()));
        LogicalOrOperator op = this.baseTypeFactory.createLogicalOrOperator();
        op.setName("|");
        res.setOp((LogicalOperator)op);
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitExclusiveOrExpression(ExclusiveOrExpression e) throws Exception {
        LogicalOrExpression res = this.smvFactory.createLogicalOrExpression();
        res.setLeft(this.get(e.getLeft()));
        res.setRight(this.get(e.getRight()));
        LogicalOrOperator op = this.baseTypeFactory.createLogicalOrOperator();
        op.setName("xor");
        res.setOp((LogicalOperator)op);
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitAndExpression(AndExpression e) throws Exception {
        LogicalAndExpression res = this.smvFactory.createLogicalAndExpression();
        res.setLeft(this.get(e.getLeft()));
        res.setRight(this.get(e.getRight()));
        LogicalAndOperator op = this.baseTypeFactory.createLogicalAndOperator();
        op.setName("&");
        res.setOp((LogicalOperator)op);
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitEqualityExpression(eu.fbk.tools.editor.c.expression.expression.EqualityExpression e) throws Exception {
        EqualityExpression res = this.smvFactory.createEqualityExpression();
        res.setLeft(this.get(e.getLeft()));
        res.setRight(this.get(e.getRight()));
        EqualityOperator op = this.baseTypeFactory.createEqualityOperator();
        if (e.getOp().equals("==")) {
            op.setName("=");
        } else if (e.getOp().equals("!=")) {
            op.setName("!=");
        } else {
            throw new Exception("Operator not valid: " + e.getOp());
        }
        res.setOp((Operator)op);
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitRelationalExpression(RelationalExpression e) throws Exception {
        eu.fbk.tools.editor.nusmv.smv.RelationalExpression res = this.smvFactory.createRelationalExpression();
        RelationalOperator op = this.baseTypeFactory.createRelationalOperator();
        String eop = e.getOp();
        op.setName(eop);
        res.setLeft(this.get(e.getLeft()));
        res.setRight(this.get(e.getRight()));
        res.setOp((Operator)op);
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitShiftExpression(ShiftExpression e) throws Exception {
        throw new Exception("Shift Expressions not supported.");
    }

    protected void visitAdditiveExpression(AdditiveExpression e) throws Exception {
        AddSubExpression res = this.smvFactory.createAddSubExpression();
        String eop = e.getOp();
        AddSubOperator op = this.baseTypeFactory.createAddSubOperator();
        op.setName(eop);
        res.setLeft(this.get(e.getLeft()));
        res.setRight(this.get(e.getRight()));
        res.setOp((Operator)op);
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitMultiplicativeExpression(MultiplicativeExpression e) throws Exception {
        MulDivExpression res = this.smvFactory.createMulDivExpression();
        String eop = e.getOp();
        ExtendedMulDivOperator op = this.baseTypeFactory.createExtendedMulDivOperator();
        op.setName(eop);
        res.setLeft(this.get(e.getLeft()));
        res.setRight(this.get(e.getRight()));
        res.setOp((Operator)op);
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitCastExpression(CastExpression e) throws Exception {
        throw new Exception("Cast Expressions not supported.");
    }

    protected void visitUnaryExpression(UnaryExpression e) throws Exception {
        String eop = e.getOp();
        if (eop.equals("+") || eop.equals("-")) {
            UnaryAlgebraicExpression res = this.smvFactory.createUnaryAlgebraicExpression();
            UnaryAlgebraicOperator op = this.baseTypeFactory.createUnaryAlgebraicOperator();
            op.setName(eop);
            res.setOp((Operator)op);
            res.setOperand(this.get(e.getRight()));
            this.exprCache.put((Object)e, (Object)res);
        } else if (eop.equals("~") || eop.equals("!")) {
            UnaryLogicalExpression res = this.smvFactory.createUnaryLogicalExpression();
            UnaryLogicalOperator op = this.baseTypeFactory.createUnaryLogicalOperator();
            op.setName("!");
            res.setOp((Operator)op);
            res.setOperand(this.get(e.getRight()));
            this.exprCache.put((Object)e, (Object)res);
        }
    }

    protected void visitPostfixExpression(PostfixExpression e) throws Exception {
        if (e.getIndex() != null) {
            throw new Exception("Array Expressions not supported.");
        }
        if (e.getLeft() != null && e.getRight() == null) {
            Identifier i = (Identifier)e.getLeft();
            if (i == null) {
                throw new Exception("Unsupported Function Call Expression: " + e.toString());
            }
            eu.fbk.tools.editor.basetype.baseType.Identifier id = this.baseTypeFactory.createIdentifier();
            id.setValue(i.getName());
            EList argList = null;
            if (e.getArgumentList() != null) {
                argList = e.getArgumentList().getExpression();
            }
            if (i.getName().equals("next")) {
                NextExpression res = this.smvFactory.createNextExpression();
                if (argList == null || argList.size() != 1) {
                    throw new Exception("No Expression inside next: " + e.toString());
                }
                res.setExpression(this.get((Expression)argList.get(0)));
                this.exprCache.put((Object)e, (Object)res);
            } else if (i.getName().equals("abs")) {
                AbsExpression res = this.smvFactory.createAbsExpression();
                if (argList == null || argList.size() != 1) {
                    throw new Exception("No Expression inside abs: " + e.toString());
                }
                res.setArgument(this.get((Expression)argList.get(0)));
                this.exprCache.put((Object)e, (Object)res);
            } else if (i.getName().equals("count")) {
                CountExpression res = this.smvFactory.createCountExpression();
                if (argList == null) {
                    throw new Exception("No Expression inside count: " + e.toString());
                }
                for (Expression arg : argList) {
                    res.getArguments().add((Object)this.get(arg));
                }
                this.exprCache.put((Object)e, (Object)res);
            } else if (i.getName().equals("min")) {
                MinExpression res = this.smvFactory.createMinExpression();
                if (argList == null || argList.size() != 2) {
                    throw new Exception("Missing Expression inside min: " + e.toString());
                }
                res.setArgument1(this.get((Expression)argList.get(0)));
                res.setArgument2(this.get((Expression)argList.get(1)));
                this.exprCache.put((Object)e, (Object)res);
            } else if (i.getName().equals("max")) {
                MaxExpression res = this.smvFactory.createMaxExpression();
                if (argList == null || argList.size() != 2) {
                    throw new Exception("Missing Expression inside max: " + e.toString());
                }
                res.setArgument1(this.get((Expression)argList.get(0)));
                res.setArgument2(this.get((Expression)argList.get(1)));
                this.exprCache.put((Object)e, (Object)res);
            } else {
                if (i.getName().equals("sin") || i.getName().equals("cos") || i.getName().equals("tan") || i.getName().equals("exp") || i.getName().equals("ln") || i.getName().equals("pow") || i.getName().equals("floor") || i.getName().equals("extend") || i.getName().equals("resize") || i.getName().equals("swconst") || i.getName().equals("uwconst") || i.getName().equals("word1") || i.getName().equals("bool") || i.getName().equals("toint") || i.getName().equals("signed") || i.getName().equals("unsigned") || i.getName().equals("sizeof")) {
                    throw new Exception("Unsupported Function Call: " + i.getName());
                }
                UserFunctionExpression res = this.smvFactory.createUserFunctionExpression();
                res.setFunction(id);
                if (argList != null) {
                    for (Expression arg : argList) {
                        res.getArguments().add((Object)this.get(arg));
                    }
                }
                this.exprCache.put((Object)e, (Object)res);
            }
        } else if (e.getLeft() != null && e.getRight() != null) {
            throw new Exception("Dot Notation not supported.");
        }
    }

    protected void visitParsExpression(ParsExpression e) throws Exception {
        BoundedExpression res = this.smvFactory.createBoundedExpression();
        res.setExpression(this.get(e.getExp()));
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitIdentifier(Identifier e) throws Exception {
        ComplexIdentifier res = this.smvFactory.createComplexIdentifier();
        eu.fbk.tools.editor.basetype.baseType.Identifier id = this.baseTypeFactory.createIdentifier();
        id.setValue(e.getName());
        res.setIdentifier(id);
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitDecimalLiteral(DecimalLiteral e) throws Exception {
        IntegerLiteral res = this.baseTypeFactory.createIntegerLiteral();
        res.setValue(e.getValue());
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitFloatingPointLiteral(FloatingPointLiteral e) throws Exception {
        RealLiteral res = this.baseTypeFactory.createRealLiteral();
        res.setValue(e.getValue());
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitBooleanLiteral(eu.fbk.tools.editor.c.expression.expression.BooleanLiteral e) throws Exception {
        BooleanLiteral res = this.baseTypeFactory.createBooleanLiteral();
        if (e.getValue().equals("true")) {
            res.setValue("TRUE");
        } else if (e.getValue().equals("false")) {
            res.setValue("FALSE");
        } else {
            res.setValue(e.getValue());
        }
        this.exprCache.put((Object)e, (Object)res);
    }

    protected void visitAllExpression(AllExpression e) throws Exception {
        throw new Exception("AllExpression not supported.");
    }
}

