/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.services;

import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.StateMachineModelToSmvModelTranslator;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.utils.SmvModelUtil;
import eu.fbk.eclipse.standardtools.utils.core.exceptions.NoComponentException;
import eu.fbk.eclipse.standardtools.utils.core.exceptions.NoStateMachineException;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class SMVTranslatorServiceAPI {
    private static final Logger logger = Logger.getLogger(SMVTranslatorServiceAPI.class);
    private StateMachineModelToSmvModelTranslator stateMachineModelToSmvModelTranslator;
    private SmvModelUtil smvModelUtil = SmvModelUtil.getInstance();
    private AbstractStateMachineModel abstractStateMachineModel;
    private AbstractSystemModel abstractSystemModel;
    private static SMVTranslatorServiceAPI smvTranslatorService;

    public static SMVTranslatorServiceAPI getInstance(AbstractSystemModel abstractSystemModel, AbstractStateMachineModel abstractStateMachineModel) {
        if (smvTranslatorService == null) {
            smvTranslatorService = new SMVTranslatorServiceAPI(abstractSystemModel, abstractStateMachineModel);
        }
        return smvTranslatorService;
    }

    public SMVTranslatorServiceAPI(AbstractSystemModel abstractSystemModel, AbstractStateMachineModel abstractStateMachineModel) {
        this.abstractStateMachineModel = abstractStateMachineModel;
        this.abstractSystemModel = abstractSystemModel;
        this.stateMachineModelToSmvModelTranslator = StateMachineModelToSmvModelTranslator.getInstance(abstractStateMachineModel);
    }

    public void exportAllNominalStateMachinesOfTheModel(Object model, String selectedDirectory, String fileName, IProgressMonitor monitor) throws Exception {
        Set stateMachines = this.abstractStateMachineModel.getAllStateMachinesFromModel(model);
        logger.debug((Object)("stateMachines.size: " + stateMachines.size()));
        for (Object stateMachine : stateMachines) {
            smvTranslatorService.exportStateMachineToSmvFile(stateMachine, selectedDirectory, null, monitor);
        }
    }

    public void exportNominalStateMachines(Object umlSelectedComponent, String selectedDirectory, String fileName, IProgressMonitor monitor) throws Exception {
        Set stateMachines = this.abstractStateMachineModel.getNominalStateMachinesIncludingFromSubComponents(umlSelectedComponent);
        for (Object stateMachine : stateMachines) {
            smvTranslatorService.exportStateMachineToSmvFile(stateMachine, selectedDirectory, null, monitor);
        }
    }

    public File exportStateMachineOfComponentToSMVFile(Object umlSelectedComponent, boolean showPopups, String selectedDirectory, IProgressMonitor monitor) throws Exception {
        if (umlSelectedComponent == null) {
            throw new NoComponentException();
        }
        File smvFile = null;
        Object stateMachine = this.abstractStateMachineModel.getFirstNominalStateMachine(umlSelectedComponent);
        if (stateMachine != null) {
            smvFile = smvTranslatorService.exportStateMachineToSmvFile(stateMachine, selectedDirectory, this.abstractSystemModel.getComponentName(umlSelectedComponent), monitor);
            return smvFile;
        }
        throw new NoStateMachineException();
    }

    public HashMap<String, String> exportAllStateMachinesToSMVFiles(Object umlSelectedComponent, String selectedDirectory, IProgressMonitor monitor) throws Exception {
        if (umlSelectedComponent == null) {
            throw new NoComponentException();
        }
        HashMap<String, String> mapSmvFile_ComponentName = new HashMap<String, String>();
        Set stateMachines = this.abstractStateMachineModel.getNominalStateMachinesIncludingFromSubComponents(umlSelectedComponent);
        if (stateMachines != null && stateMachines.size() > 0) {
            for (Object stateMachine : stateMachines) {
                String componentName = this.abstractSystemModel.getComponentName(this.abstractStateMachineModel.getStateMachineOwner(stateMachine));
                logger.debug((Object)"exportStateMachineToSmvFile");
                File smvFile = smvTranslatorService.exportStateMachineToSmvFile(stateMachine, selectedDirectory, componentName, monitor);
                logger.debug((Object)"exportStateMachineToSmvFile done");
                mapSmvFile_ComponentName.put(smvFile.getPath(), componentName);
            }
        } else {
            throw new NoStateMachineException();
        }
        logger.debug((Object)"exportSmv exportStateMachineToSmvFile done");
        return mapSmvFile_ComponentName;
    }

    public File exportStateMachineToSmvFile(Object umlSelectedStateMachine, String selectedDirectory, String fileName, IProgressMonitor monitor) throws Exception {
        Object smvModel = this.stateMachineModelToSmvModelTranslator.exportStateMachineAsSmvModel(umlSelectedStateMachine, monitor);
        if (fileName == null) {
            fileName = this.stateMachineModelToSmvModelTranslator.getFileName(umlSelectedStateMachine);
        }
        File smvFile = this.exportSMVModelToSMVFile(smvModel, selectedDirectory, fileName, monitor);
        return smvFile;
    }

    private File exportSMVModelToSMVFile(Object smvModel, String selectedDirectory, String fileName, IProgressMonitor monitor) throws Exception {
        return this.smvModelUtil.generateSmvFileFromSmvModel(selectedDirectory, fileName, smvModel, monitor);
    }
}

