/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import org.eclipse.papyrus.infra.core.sasheditor.internal.AbstractPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IPartVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PagePart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PartLists;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabFolderPart;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class TabItemPart {
    protected PagePart childPart;
    protected TabFolderPart parent;
    protected CTabItem control;
    protected AbstractPart.GarbageState garbageState;

    public TabItemPart(TabFolderPart parent, PagePart modelPart, int index) {
        this.parent = parent;
        this.childPart = modelPart;
        this.createItemControl(index);
    }

    public void createItemControl(int index) {
        CTabItem item;
        this.control = item = new CTabItem(this.getTabFolder(), 0, index);
        if (this.childPart != null) {
            item.setControl(this.childPart.getControl());
            this.refreshTabDecorations();
        }
    }

    public void refreshTabDecorations() {
        this.setTabText(this.childPart.getPageTitle());
        this.setTabImage(this.childPart.getPageIcon());
        this.control.setShowClose(this.childPart.canClose());
    }

    protected void resetChild(PagePart newChild) {
        this.childPart.orphan();
        newChild.reparent(this.parent);
        this.childPart = newChild;
        this.setItemControl(this.childPart.getControl());
        this.refreshTabDecorations();
    }

    private CTabFolder getTabFolder() {
        return (CTabFolder)this.parent.getControl();
    }

    public void fillPartMap(PartLists partMap) {
        this.childPart.fillPartMap(partMap);
        this.garbageState = AbstractPart.GarbageState.UNVISITED;
    }

    protected void remove() {
        this.setItemControl(null);
        this.parent = null;
        this.control.dispose();
        this.childPart.orphan();
    }

    private void setItemControl(Control newControl) {
        boolean editorIsVisible = false;
        Control editorControl = this.control.getControl();
        if (editorControl != null && editorControl.getParent() != this.control.getParent()) {
            editorIsVisible = editorControl.getVisible();
            this.control.setControl(newControl);
            if (editorIsVisible) {
                editorControl.setVisible(editorIsVisible);
            }
        } else {
            this.control.setControl(newControl);
        }
    }

    public void disposeThisAndChildren() {
        if (this.childPart != null) {
            this.childPart.disposeThisAndChildren();
            this.childPart = null;
        }
        this.parent = null;
    }

    private void setTabImage(Image titleImage) {
        this.control.setImage(titleImage);
    }

    private void setTabText(String title) {
        if (title == null) {
            title = "";
        }
        this.control.setText(title);
        this.control.setToolTipText(title);
    }

    public PagePart getChildPart() {
        return this.childPart;
    }

    public AbstractPart findPartAt(Point position, Class<?> expectedTileType) {
        return this.childPart.findPartAt(position, expectedTileType);
    }

    public boolean visit(IPartVisitor visitor) {
        return visitor.accept(this);
    }

    public boolean visitChildren(IPartVisitor visitor) {
        return this.childPart.visit(visitor);
    }

    public boolean isTabItemFor(Object rawModel) {
        return rawModel.equals(this.getChildPart().getRawModel());
    }
}

