/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.views.trace.contract.implementation;

import eu.fbk.tools.adapter.results.CheckResult;
import eu.fbk.tools.adapter.results.ContractCheckResult;
import eu.fbk.tools.adapter.results.ModelCheckResult;
import eu.fbk.tools.adapter.results.Trace;
import eu.fbk.tools.adapter.ui.views.trace.TraceTreeObject;
import eu.fbk.tools.adapter.ui.views.trace.contract.implementation.ContractTreeObject;
import eu.fbk.tools.adapter.ui.views.tree.FailureTreeObject;
import eu.fbk.tools.adapter.ui.views.tree.SuccessTreeObject;
import eu.fbk.tools.adapter.ui.views.tree.TreeViewContentProvider;
import eu.fbk.tools.adapter.ui.views.tree.UnknownTreeObject;
import java.util.Comparator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.Viewer;

public class ContractTraceTreeViewContentProvider
extends TreeViewContentProvider {
    private ModelCheckResult resultModel;

    @Override
    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput instanceof ModelCheckResult) {
            this.resultModel = (ModelCheckResult)newInput;
        }
        super.inputChanged(v, oldInput, newInput);
    }

    @Override
    protected void initialize() {
        if (this.getInvisibleRoot() == null) {
            return;
        }
        this.getInvisibleRoot().clear();
        if (this.resultModel == null) {
            return;
        }
        this.showCheckContractResult();
    }

    private void showCheckContractResult() {
        EList contractCheckResults = this.resultModel.getContractCheckResults();
        ECollections.sort((EList)contractCheckResults, (Comparator)new Comparator<ContractCheckResult>(){

            @Override
            public int compare(ContractCheckResult o1, ContractCheckResult o2) {
                return o1.getTimeStamp() > o2.getTimeStamp() ? -1 : 1;
            }
        });
        for (ContractCheckResult contractCheckResult : contractCheckResults) {
            ContractTreeObject contractTreeObject = new ContractTreeObject(contractCheckResult.getContractName(), "[" + contractCheckResult.getComponentType() + "] " + contractCheckResult.getContractName());
            contractTreeObject.setContentProvider(contractCheckResult);
            contractTreeObject.setTooltip("Component type: " + contractCheckResult.getComponentType() + "\nContract name: " + contractCheckResult.getContractName());
            this.getInvisibleRoot().addChild(contractTreeObject);
            if (contractCheckResult.getFailed() == null || contractCheckResult.getFailed() != null && !contractCheckResult.getFailed().booleanValue()) {
                contractTreeObject.addChild(new SuccessTreeObject());
                continue;
            }
            EList checkResults = contractCheckResult.getCheckResults();
            if (checkResults == null || checkResults.isEmpty()) {
                contractTreeObject.addChild(new UnknownTreeObject("Check result not available"));
                continue;
            }
            contractTreeObject.addChild(new FailureTreeObject());
            for (CheckResult checkResult : checkResults) {
                EList traces = checkResult.getTraces();
                if (traces == null) continue;
                for (Trace trace : traces) {
                    StringBuffer message = new StringBuffer();
                    StringBuffer tooltip = new StringBuffer();
                    tooltip.append("Proof type: ").append(checkResult.getProofType());
                    if (checkResult.getContractName() != null && !checkResult.getContractName().isEmpty()) {
                        String contractName = checkResult.getContractName();
                        if (contractName.contains(".")) {
                            String[] matches = contractName.split("\\.");
                            tooltip.append("\nSub component: ").append(matches[0]);
                            tooltip.append("\nContract name: ").append(matches[1]);
                            message.append("[").append(matches[0]).append("]");
                            message.append(" ").append(matches[1]);
                        } else {
                            tooltip.append("\nContract name: ").append(contractName);
                            message.append(contractName);
                        }
                    }
                    TraceTreeObject traceTreeObject = new TraceTreeObject(trace.getId(), "Model");
                    traceTreeObject.setContentProvider(trace);
                    contractTreeObject.addChild(traceTreeObject);
                    traceTreeObject.setTooltip(tooltip.toString());
                }
            }
        }
    }
}

