/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.views.trace.behaviour;

import eu.fbk.tools.adapter.results.BehaviourCheckResult;
import eu.fbk.tools.adapter.results.CheckResult;
import eu.fbk.tools.adapter.results.ModelCheckResult;
import eu.fbk.tools.adapter.results.Trace;
import eu.fbk.tools.adapter.ui.views.trace.BehaviourTreeObject;
import eu.fbk.tools.adapter.ui.views.trace.TraceTreeObject;
import eu.fbk.tools.adapter.ui.views.tree.FailureTreeObject;
import eu.fbk.tools.adapter.ui.views.tree.SuccessTreeObject;
import eu.fbk.tools.adapter.ui.views.tree.TreeViewContentProvider;
import eu.fbk.tools.adapter.ui.views.tree.UnknownTreeObject;
import java.util.Comparator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.Viewer;

public class BehaviourTraceTreeViewContentProvider
extends TreeViewContentProvider {
    private ModelCheckResult resultModel;

    @Override
    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput instanceof ModelCheckResult) {
            this.resultModel = (ModelCheckResult)newInput;
        }
        super.inputChanged(v, oldInput, newInput);
    }

    @Override
    protected void initialize() {
        if (this.getInvisibleRoot() == null) {
            return;
        }
        this.getInvisibleRoot().clear();
        if (this.resultModel == null) {
            return;
        }
        this.showCheckBehaviourResult();
    }

    private void showCheckBehaviourResult() {
        EList behaviourCheckResults = this.resultModel.getBehaviourCheckResults();
        ECollections.sort((EList)behaviourCheckResults, (Comparator)new Comparator<BehaviourCheckResult>(){

            @Override
            public int compare(BehaviourCheckResult o1, BehaviourCheckResult o2) {
                return o1.getTimeStamp() > o2.getTimeStamp() ? -1 : 1;
            }
        });
        for (BehaviourCheckResult behaviourCheckResult : behaviourCheckResults) {
            BehaviourTreeObject behaviourTreeObject = new BehaviourTreeObject("Behaviour", "Model");
            behaviourTreeObject.setContentProvider(behaviourCheckResult);
            this.getInvisibleRoot().addChild(behaviourTreeObject);
            if (behaviourCheckResult.getFailed() == null || behaviourCheckResult.getFailed() != null && !behaviourCheckResult.getFailed().booleanValue()) {
                behaviourTreeObject.addChild(new SuccessTreeObject());
                continue;
            }
            EList checkResults = behaviourCheckResult.getCheckResults();
            if (checkResults == null || checkResults.isEmpty()) {
                behaviourTreeObject.addChild(new UnknownTreeObject("Check result not available"));
                continue;
            }
            behaviourTreeObject.addChild(new FailureTreeObject());
            for (CheckResult checkResult : checkResults) {
                EList traces = checkResult.getTraces();
                if (traces == null) continue;
                for (Trace trace : traces) {
                    StringBuffer tooltip = new StringBuffer();
                    tooltip.append("Proof type: ").append(checkResult.getProofType());
                    TraceTreeObject traceTreeObject = new TraceTreeObject(trace.getId(), "Model");
                    traceTreeObject.setContentProvider(trace);
                    behaviourTreeObject.addChild(traceTreeObject);
                    traceTreeObject.setTooltip(tooltip.toString());
                }
            }
        }
    }
}

