/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.views.trace;

import eu.fbk.tools.adapter.results.Trace;
import eu.fbk.tools.adapter.ui.Activator;
import eu.fbk.tools.adapter.ui.views.trace.TraceTreeObject;
import eu.fbk.tools.adapter.ui.views.trace.TraceViewPart;
import eu.fbk.tools.adapter.ui.views.tree.TreeRoot;
import eu.fbk.tools.adapter.ui.views.tree.TreeViewContentProvider;
import eu.fbk.tools.adapter.ui.views.tree.TreeViewLableProvider;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class BaseTraceViewer
extends TraceViewPart {
    protected TreeViewer treeViewer;
    protected Grid tableViewer;
    protected final Map<String, GridItem> gridItems = new Hashtable<String, GridItem>();
    protected boolean showAllAssignments = true;
    private Trace trace;
    protected final TreeViewContentProvider contentProvider;

    public BaseTraceViewer(TreeViewContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void createPartControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 0);
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new FillLayout(256));
        this.treeViewer = new TreeViewer(composite, 2816);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeViewLableProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.setInput((Object)new TreeRoot());
        this.treeViewer.expandAll();
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedElement;
                BaseTraceViewer.this.clearGrid();
                ISelection selection = event.getSelection();
                if (selection != null && selection instanceof TreeSelection && (selectedElement = ((TreeSelection)selection).getFirstElement()) instanceof TraceTreeObject) {
                    BaseTraceViewer.this.trace = (Trace)((TraceTreeObject)selectedElement).getContentProvider();
                    BaseTraceViewer.this.loadGrid();
                }
            }
        });
        composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new FillLayout(256));
        this.tableViewer = new Grid(composite, 2816);
        this.tableViewer.setAutoWidth(true);
        this.tableViewer.setHeaderVisible(true);
        sashForm.setWeights(new int[]{1, 4});
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
    }

    @Override
    public void refresh() {
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
        this.clearGrid();
    }

    @Override
    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void createActions() {
    }

    private void clearGrid() {
        this.gridItems.clear();
        this.tableViewer.disposeAllItems();
        this.deleteColumns();
    }

    private void loadGrid() {
        this.createColumns(this.trace);
        this.tableViewer.recalculateHeader();
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.tableViewer);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.removeAll();
                BaseTraceViewer.this.fillContextMenu(mgr);
            }
        });
        this.tableViewer.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        if (this.trace == null || this.trace.getStates().isEmpty()) {
            return;
        }
        menuManager.add((IContributionItem)new GroupMarker("additions"));
        this.addShowAssignementMenu(menuManager);
    }

    protected void addShowAssignementMenu(IMenuManager manager) {
        Action action = new Action("Show all assignments", 2){

            public void run() {
                BaseTraceViewer.this.showAllAssignments = !BaseTraceViewer.this.showAllAssignments;
                BaseTraceViewer.this.clearGrid();
                BaseTraceViewer.this.loadGrid();
            }
        };
        ImageDescriptor image = Activator.getImageDescriptor("icons/zoom.png");
        if (image != null) {
            action.setImageDescriptor(image);
        }
        action.setChecked(this.showAllAssignments);
        manager.add((IAction)action);
    }

    public void setFocus() {
    }

    private void deleteColumns() {
        GridColumnGroup[] gridColumnGroupArray = this.tableViewer.getColumnGroups();
        int n = gridColumnGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumnGroup cg = gridColumnGroupArray[n2];
            cg.dispose();
            ++n2;
        }
        gridColumnGroupArray = this.tableViewer.getColumns();
        n = gridColumnGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            GridColumnGroup c = gridColumnGroupArray[n2];
            c.dispose();
            ++n2;
        }
    }

    protected void createColumns(Trace trace) {
    }

    protected boolean areAllValuesIdentical(List<String> values) {
        if (values.size() <= 1) {
            return true;
        }
        int i = 1;
        while (i < values.size()) {
            if (!values.get(i - 1).equals(values.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void populatePortName(String variable) {
        String[] componentsAndPort = variable.split("\\.");
        if (!this.gridItems.containsKey(componentsAndPort[0])) {
            GridItem item = new GridItem(this.tableViewer, 0);
            item.setText(componentsAndPort[0]);
            item.setExpanded(true);
            this.gridItems.put(componentsAndPort[0], item);
        }
        if (componentsAndPort.length > 1) {
            this.populatePort(variable, 1, this.gridItems.get(componentsAndPort[0]));
        }
    }

    protected void populatePort(String variable, int index, GridItem parentItem) {
        String[] componentsAndPort = variable.split("\\.");
        String fullCurrentComponentName = componentsAndPort[0];
        int i = 1;
        while (i <= index) {
            fullCurrentComponentName = String.valueOf(fullCurrentComponentName) + "." + componentsAndPort[i];
            ++i;
        }
        if (!this.gridItems.containsKey(fullCurrentComponentName)) {
            GridItem item = new GridItem(parentItem, 0);
            item.setText(componentsAndPort[index]);
            item.setExpanded(true);
            this.gridItems.put(fullCurrentComponentName, item);
        }
        if (++index < componentsAndPort.length) {
            this.populatePort(variable, index, this.gridItems.get(fullCurrentComponentName));
        }
    }
}

