/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.views.faulttree;

import eu.fbk.tools.adapter.ui.views.faulttree.EventTreeObject;
import eu.fbk.tools.adapter.ui.views.faulttree.GateTreeObject;
import eu.fbk.tools.adapter.ui.views.tree.TreeObject;
import eu.fbk.tools.adapter.ui.views.tree.TreeViewContentProvider;
import eu.fbk.tools.adapter.xsap.tree.FaultTree;
import eu.fbk.tools.adapter.xsap.tree.GateType;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;

public class FaultTreeViewContentProvider
extends TreeViewContentProvider {
    private FaultTree faultTreeModel;

    @Override
    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput instanceof FaultTree) {
            this.faultTreeModel = (FaultTree)newInput;
        }
        super.inputChanged(v, oldInput, newInput);
    }

    @Override
    protected void initialize() {
        if (this.getInvisibleRoot() == null) {
            return;
        }
        this.getInvisibleRoot().clear();
        if (this.faultTreeModel == null) {
            return;
        }
        this.show();
    }

    private void show() {
        GateType gate = this.faultTreeModel.getGate();
        GateTreeObject gateTreeObject = new GateTreeObject(gate.getName(), gate.getDescription(), gate.getType());
        gateTreeObject.setContentProvider(this.faultTreeModel);
        this.getInvisibleRoot().addChild(gateTreeObject);
        this.showEvents(gateTreeObject, gate.getEvent());
        this.showGates(gateTreeObject, gate.getGate());
    }

    private void showGates(TreeObject parentTreeObject, List<GateType> gates) {
        for (GateType gate : gates) {
            GateTreeObject gateTreeObject = new GateTreeObject(gate.getName(), gate.getDescription(), gate.getType());
            parentTreeObject.addChild(gateTreeObject);
            this.showEvents(gateTreeObject, gate.getEvent());
            this.showGates(gateTreeObject, gate.getGate());
        }
    }

    private void showEvents(TreeObject parentTreeObject, List<GateType.Event> events) {
        for (GateType.Event event : events) {
            EventTreeObject gateTreeObject = new EventTreeObject(event.getName(), event.getDescription());
            parentTreeObject.addChild(gateTreeObject);
        }
    }
}

