/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.progress;

import eu.fbk.tools.Request;
import eu.fbk.tools.RequestProvider;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ToolRunner;
import eu.fbk.tools.adapter.oslc.OslcToolConsumer;
import eu.fbk.tools.adapter.ui.Activator;
import eu.fbk.tools.adapter.ui.result.ResultProcessor;
import eu.fbk.tools.adapter.ui.result.ResultProcessorFactory;
import eu.fbk.tools.adapter.ui.views.request.RequestView;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolJob
extends Job {
    private static final Logger logger = LoggerFactory.getLogger(ToolJob.class);
    private final Request request;
    private final ToolRunner runner;
    private boolean headlessMode = false;

    public ToolJob(String name, ToolRunner runner) {
        super(name);
        this.runner = runner;
        this.request = new Request(UUID.randomUUID().toString());
    }

    public ToolRunner getRunner() {
        return this.runner;
    }

    public Request getRequest() {
        return this.request;
    }

    public boolean isHeadlessMode() {
        return this.headlessMode;
    }

    public void setHeadlessMode(boolean headlessMode) {
        this.headlessMode = headlessMode;
    }

    protected IStatus run(IProgressMonitor monitor) {
        block25: {
            if (this.runner == null) {
                this.request.setNotes("Internal error while executing the command");
                logger.error(String.valueOf(this.request.getNotes()) + ". The runner is null");
                this.jobFail();
                return Status.CANCEL_STATUS;
            }
            String logLevel = Activator.getDefault().getPreferenceStore().getString("debug.logLevel");
            if (logLevel.equals("DEBUG")) {
                this.runner.setDebugMode(true);
            } else {
                this.runner.setDebugMode(false);
            }
            ToolFunction function = this.runner.getToolFunction();
            this.request.setFunctionName(function.getName());
            this.request.setStatus(Request.RequestStatus.in_progress);
            this.request.setTimestamp(new Date());
            this.request.setResultStatus(Request.ResultStatus.unknown);
            if (this.getRunner().getExtResultFile() != null) {
                this.request.setExtResultFile(this.runner.getExtResultFile().toString());
            }
            String userName = StringUtils.isBlank((CharSequence)System.getProperty("user.name")) ? "unknown" : System.getProperty("user.name");
            this.request.setUser(userName);
            RequestProvider.getInstance().addRequest(this.request);
            this.displayRequestView();
            if (!this.headlessMode) {
                monitor.beginTask("Executing the command ...", -1);
            }
            try {
                OslcToolConsumer osclConsumer;
                Integer exitStatus;
                Triple output = this.runner.runTool();
                if (!this.headlessMode) {
                    monitor.done();
                }
                if (output == null) {
                    this.request.setNotes("Unexpected fully empty result");
                    logger.error(String.valueOf(this.request.getNotes()) + ". The output is null");
                    this.jobFail();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                String errorMessage = (String)output.getRight();
                if (!StringUtils.isBlank((CharSequence)errorMessage)) {
                    this.request.setNotes(errorMessage);
                }
                if ((exitStatus = (Integer)output.getLeft()) != 0) {
                    this.displayError(function.getName(), errorMessage);
                    this.runner.killToolRunnerProcess();
                    this.jobFail();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (this.runner.getResultFile() != null) {
                    this.request.setResultFile(this.runner.getResultFile().toString());
                }
                if (this.runner instanceof OslcToolConsumer && (osclConsumer = (OslcToolConsumer)this.runner).getRequestUri() != null) {
                    this.request.setRequestUri(osclConsumer.getRequestUri().toString());
                }
                if (this.getRunner().isAsynchronousExecution()) break block25;
                String functionName = this.runner.getToolFunction().getName();
                ResultProcessor resultProcessor = ResultProcessorFactory.getProcessor(functionName);
                if (this.runner.getResultFile() != null) {
                    resultProcessor.setResultFile(this.runner.getResultFile());
                    resultProcessor.setExtResultFile(this.runner.getExtResultFile());
                }
                if (!resultProcessor.processResult()) {
                    this.request.setNotes("Error processing the command result");
                    logger.error(this.request.getNotes());
                    this.runner.killToolRunnerProcess();
                    this.jobFail();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                try {
                    if (!this.headlessMode) {
                        resultProcessor.displayResult();
                    }
                    this.jobSucceed();
                }
                catch (TimeoutException timeoutException) {
                    this.request.setNotes("Timeout expired");
                    logger.error(this.request.getNotes());
                    this.displayError(function.getName(), "Timeout expired. Try to increase the timeout in the preferences.");
                    this.runner.killToolRunnerProcess();
                    this.jobFail();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    this.request.setNotes("Internal error while executing the command");
                    logger.error(this.request.getNotes(), (Object)e.getMessage());
                    this.displayError(function.getName(), "Internal error while executing the command. For more info see the console");
                    this.runner.killToolRunnerProcess();
                    this.jobFail();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
            }
            finally {
                OslcToolConsumer osclConsumer;
                this.request.setWorkingDir(this.runner.getSessionWorkspaceDir().toString());
                if (this.runner instanceof OslcToolConsumer && (osclConsumer = (OslcToolConsumer)this.runner).getRequestUri() != null) {
                    this.request.setRequestUri(osclConsumer.getRequestUri().toString());
                }
                this.displayRequestView();
            }
        }
        return Status.OK_STATUS;
    }

    protected void displayError(String title, String errorMsg) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)title, (String)errorMsg);
        });
    }

    protected void canceling() {
        if (this.runner != null) {
            this.runner.killToolRunnerProcess();
        }
    }

    protected String getCheckerExecutable() {
        return null;
    }

    protected void jobSucceed() {
        this.requestEnd(Request.ResultStatus.available);
    }

    protected void jobFail() {
        this.requestEnd(Request.ResultStatus.failure);
    }

    protected void requestEnd(Request.ResultStatus status) {
        this.request.setStatus(Request.RequestStatus.completed);
        this.request.setDuration(Float.valueOf((float)this.getRunner().getExecutionDuration() / 1000.0f));
        this.request.setResultStatus(status);
    }

    protected void displayRequestView() {
        Display.getDefault().asyncExec(() -> {
            try {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                RequestView viewPart = (RequestView)activePage.showView("eu.fbk.tools.adapter.ui.views.request.RequestView", null, 2);
                if (viewPart != null) {
                    TableViewer requestViewer = viewPart.getViewer();
                    IContentProvider provider = requestViewer.getContentProvider();
                    if (provider == null) {
                        return;
                    }
                    requestViewer.refresh();
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        });
    }
}

