/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.preferences.tools;

import eu.fbk.tools.adapter.oslc.OslcServiceProviderCatalogConsumer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class OslcToolPreferences {
    private final IPreferenceStore preferenceStore;
    private StringFieldEditor baseUrlFieldEditor;
    private StringFieldEditor catalogPathFieldEditor;
    private final Map<String, String> selectedServiceProviders = new Hashtable<String, String>();
    private List<OslcServiceProviderCatalogConsumer.ServiceDescription> serviceDescriptions;
    private final List<FieldEditor> fieldEditors = new ArrayList<FieldEditor>();
    private Composite rootComposite;
    private Table table;

    public OslcToolPreferences(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
    }

    public Composite create(Composite parent) {
        this.rootComposite = new Composite(parent, 2048);
        this.rootComposite.setLayout((Layout)new GridLayout(1, true));
        this.rootComposite.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(this.rootComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        this.baseUrlFieldEditor = new StringFieldEditor("oslc.serviceprovider.catalog.baseurl", "Service catalog base url", composite);
        this.fieldEditors.add((FieldEditor)this.baseUrlFieldEditor);
        this.catalogPathFieldEditor = new StringFieldEditor("oslc.serviceprovider.catalog.path", "Service catalog path", composite);
        this.fieldEditors.add((FieldEditor)this.catalogPathFieldEditor);
        Button loadButton = new Button(composite, 8);
        loadButton.setAlignment(0x1000000);
        loadButton.setText("Show services catalog");
        loadButton.setToolTipText("Show the services catalog");
        this.table = new Table(composite, 67616);
        this.table.setLayoutData((Object)new GridData(768));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        String[] titles = new String[]{" ", "ID", "OSLC Domain", "Publisher", "Host:Port"};
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e != null && e.getSource() instanceof Table && e.detail == 32) {
                    TableItem tableItem = (TableItem)e.item;
                    OslcToolPreferences.this.selectedServiceProviders.put(tableItem.getText(2), tableItem.getText(1));
                }
                OslcToolPreferences.this.updateServiceProviderSelection(OslcToolPreferences.this.table);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        int loopIndex = 0;
        while (loopIndex < titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(titles[loopIndex]);
            column.setWidth(50);
            column.pack();
            ++loopIndex;
        }
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    URL url = OslcToolPreferences.this.getCatalogUrl();
                    OslcServiceProviderCatalogConsumer catalogServiceProvider = new OslcServiceProviderCatalogConsumer(url.toString());
                    OslcToolPreferences.this.serviceDescriptions = catalogServiceProvider.getServiceDescriptions();
                    if (OslcToolPreferences.this.serviceDescriptions == null) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"OSCL Service Provider Catalog", (String)("Loading catalog at " + catalogServiceProvider.getServiceProviderCatalogURL().toString() + " has failed.\n\nPlease, check the connection parameters and the oslc registry availability."));
                        return;
                    }
                    OslcToolPreferences.this.selectedServiceProviders.clear();
                    OslcToolPreferences.this.showServiceProviders(OslcToolPreferences.this.table);
                }
                catch (MalformedURLException malformedURLException) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"OSCL Service Provider Catalog", (String)"Invalid service catalog url");
                }
            }
        });
        this.showServiceProviders(this.table);
        return this.rootComposite;
    }

    public List<FieldEditor> getFieldEditors() {
        return this.fieldEditors;
    }

    public void performApply() {
        try {
            this.validateCatalogUrl();
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    this.preferenceStore.setValue(item.getText(2), item.getText(1));
                }
                ++n2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"OSCL Service Provider Catalog", (String)"Invalid service catalog url");
        }
    }

    private URL validateCatalogUrl() throws MalformedURLException {
        String catalogPath = this.catalogPathFieldEditor.getStringValue();
        if (!catalogPath.startsWith("/")) {
            this.catalogPathFieldEditor.setStringValue("/" + catalogPath);
        }
        return new URL(String.valueOf(this.baseUrlFieldEditor.getStringValue()) + this.catalogPathFieldEditor.getStringValue());
    }

    private URL getCatalogUrl() throws MalformedURLException {
        return new URL(String.valueOf(this.baseUrlFieldEditor.getStringValue()) + this.catalogPathFieldEditor.getStringValue());
    }

    private void updateServiceProviderSelection(Table table) {
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String id = this.selectedServiceProviders.get(item.getText(2));
            if (id == null || !id.equals(item.getText(1))) {
                item.setChecked(false);
            } else {
                item.setChecked(true);
            }
            ++n2;
        }
    }

    private void showServiceProviders(Table table) {
        table.removeAll();
        if (this.serviceDescriptions == null) {
            return;
        }
        this.selectedServiceProviders.clear();
        for (OslcServiceProviderCatalogConsumer.ServiceDescription serviceDescription : this.serviceDescriptions) {
            String serviceProviderId = this.preferenceStore.getString(serviceDescription.domain);
            if (serviceProviderId == null || !serviceProviderId.equals(serviceDescription.serviceProviderId)) continue;
            this.selectedServiceProviders.put(serviceDescription.domain, serviceProviderId);
        }
        for (OslcServiceProviderCatalogConsumer.ServiceDescription serviceDescription : this.serviceDescriptions) {
            TableItem item = new TableItem(table, 0);
            item.setText(1, serviceDescription.serviceProviderId);
            item.setText(2, serviceDescription.domain);
            item.setText(3, serviceDescription.publisher);
            item.setText(4, serviceDescription.hostAndPort);
            String selectedServiceProviderId = this.selectedServiceProviders.get(serviceDescription.domain);
            if (selectedServiceProviderId == null) {
                this.selectedServiceProviders.put(serviceDescription.domain, serviceDescription.serviceProviderId);
                item.setChecked(true);
            } else if (serviceDescription.serviceProviderId.equals(selectedServiceProviderId)) {
                item.setChecked(true);
            }
            if (!item.getChecked()) continue;
            this.preferenceStore.setValue(item.getText(2), item.getText(1));
        }
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        table.pack();
        Display.getCurrent().getActiveShell().pack();
    }
}

