/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.preferences.tools;

import eu.fbk.tools.adapter.ToolRunner;
import eu.fbk.tools.adapter.ToolRunnerFactory;
import eu.fbk.tools.adapter.ui.Activator;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LocalToolPreferences {
    private final Map<String, ToolInfo> toolInfos = new Hashtable<String, ToolInfo>();
    private final List<FieldEditor> fieldEditors = new ArrayList<FieldEditor>();
    private Composite rootComposite;
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public Composite create(Composite parent) {
        this.rootComposite = new Composite(parent, 2048);
        this.rootComposite.setLayout((Layout)new GridLayout(1, true));
        this.rootComposite.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(this.rootComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        DirectoryFieldEditor workspaceFieldEditor = new DirectoryFieldEditor("tools.workspace", "Workspace dir", composite);
        this.fieldEditors.add((FieldEditor)workspaceFieldEditor);
        Composite composite1 = new Composite(this.rootComposite, 0);
        composite1.setLayoutData((Object)new GridData());
        this.fieldEditors.add((FieldEditor)new BooleanFieldEditor("tools.workspace.cleanup", "Cleanup workspace at next startup", composite1));
        this.draw(this.rootComposite, "OCRA", "tools.ocra.executable", "tools.ocra.timeout", "tools.ocra.executable.isvalid");
        this.draw(this.rootComposite, "nuXmv", "tools.nuxmv.executable", "tools.nuxmv.timeout", "tools.nuxmv.executable.isvalid");
        this.draw(this.rootComposite, "xSAP", "tools.xsap.executable", "tools.xsap.timeout", "tools.xsap.executable.isvalid");
        this.draw(this.rootComposite, "FaultExtensionExpander", "tools.fei_expander.executable", "tools.fei_expander.timeout", "tools.fei_expander.executable.isvalid");
        return this.rootComposite;
    }

    public List<FieldEditor> getFieldEditors() {
        return this.fieldEditors;
    }

    private void draw(Composite parent, final String toolName, String keyExecutable, String keyTimeout, final String keyIsValid) {
        String[] stringArray;
        Group group = new Group(parent, 16);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(768));
        group.setText(toolName);
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(768));
        Composite composite1 = new Composite(composite, 0);
        composite1.setLayoutData((Object)new GridData(768));
        final FileFieldEditor executableFieldEditor = new FileFieldEditor(keyExecutable, "Executable", composite1);
        if (SystemUtils.IS_OS_WINDOWS) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "*.exe";
            stringArray = stringArray2;
            stringArray2[1] = "*";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "*";
            stringArray = stringArray3;
            stringArray3[1] = "*.sh";
        }
        executableFieldEditor.setFileExtensions(stringArray);
        this.fieldEditors.add((FieldEditor)executableFieldEditor);
        Button testButton = new Button(composite1, 8);
        testButton.setAlignment(0x1000000);
        testButton.setText("Test");
        testButton.setToolTipText("Test if the executable is runnable and it is the right version");
        final Label isValidLabel = new Label(composite1, 0);
        ToolInfo toolInfo = new ToolInfo();
        toolInfo.toolName = toolName;
        toolInfo.executableFileEditor = executableFieldEditor;
        toolInfo.testButton = testButton;
        toolInfo.isValidLabel = isValidLabel;
        toolInfo.isValidKey = keyIsValid;
        this.toolInfos.put(toolName, toolInfo);
        this.updateIsValidLabel(keyIsValid, isValidLabel);
        testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String toolExecutable = executableFieldEditor.getStringValue();
                ToolRunner runner = ToolRunnerFactory.getToolRunner((String)toolName, (String)toolExecutable);
                runner.setWorkspaceDir(LocalToolPreferences.this.preferenceStore.getString("tools.workspace"));
                runner.setupExecutionEnvironment();
                LocalToolPreferences.this.preferenceStore.setValue(keyIsValid, false);
                LocalToolPreferences.this.updateIsValidLabel(keyIsValid, isValidLabel);
                if (StringUtils.isBlank((String)executableFieldEditor.getStringValue())) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)("Tool - Test " + toolName), (String)(String.valueOf(toolName) + " executable was not set."));
                    return;
                }
                if (!runner.testToolExistence()) {
                    isValidLabel.setText("Executable file not exist.");
                    isValidLabel.setForeground(Display.getCurrent().getSystemColor(3));
                    return;
                }
                if (!runner.testToolInstallation()) {
                    isValidLabel.setText("Invalid installation.");
                    isValidLabel.setForeground(Display.getCurrent().getSystemColor(3));
                    return;
                }
                if (!runner.testToolExecutionPermission()) {
                    isValidLabel.setText("Wrong execution permissions.");
                    isValidLabel.setForeground(Display.getCurrent().getSystemColor(3));
                    return;
                }
                String version = runner.getToolVersion();
                if (version == null || version.isEmpty()) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)("Tool - Test " + toolName), (String)"Tool not found.");
                    return;
                }
                if (!runner.testToolVersion(version)) {
                    isValidLabel.setText("Unsupported version.");
                    isValidLabel.setForeground(Display.getCurrent().getSystemColor(3));
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)("Tool - Test " + toolName), (String)("Unsupported version " + version + ". Expected >= " + runner.getMinToolVersion()));
                } else {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)("Tool - Test " + toolName), (String)(" Found " + toolName + ", version " + (version.equals("0.0.0") ? "???" : version)));
                }
                LocalToolPreferences.this.preferenceStore.setValue(keyIsValid, true);
                LocalToolPreferences.this.updateIsValidLabel(keyIsValid, isValidLabel);
            }
        });
        Composite composite2 = new Composite(composite, 0);
        IntegerFieldEditor timeoutFieldEditor = new IntegerFieldEditor(keyTimeout, "Execution Timeout (seconds)", composite2, 4);
        timeoutFieldEditor.setValidRange(1, 28800);
        timeoutFieldEditor.setEmptyStringAllowed(false);
        this.fieldEditors.add((FieldEditor)timeoutFieldEditor);
    }

    protected void performApply() {
        this.updateAllTestButtonStatus(true);
    }

    public void propertyChange(PropertyChangeEvent event) {
        List affectedTools;
        if (event.getSource() instanceof FileFieldEditor && (affectedTools = this.toolInfos.values().stream().filter(v -> v.executableFileEditor == event.getSource()).collect(Collectors.toList())).size() == 1) {
            ToolInfo toolInfo = (ToolInfo)affectedTools.get(0);
            this.preferenceStore.setValue(toolInfo.isValidKey, false);
            this.updateIsValidLabel(toolInfo.isValidKey, toolInfo.isValidLabel);
            this.updateTestButtonStatus(toolInfo.toolName);
            this.setExecutableFieldEditorFilter(toolInfo.executableFileEditor);
        }
    }

    private void setExecutableFieldEditorFilter(FileFieldEditor executableFileNameEditor) {
        String currentValue = executableFileNameEditor.getStringValue();
        if (!StringUtils.isBlank((String)currentValue)) {
            File currentFile = new File(currentValue);
            if (currentFile.exists() && currentFile.isDirectory()) {
                executableFileNameEditor.setFilterPath(currentFile);
                System.out.println("current dir " + currentValue);
            } else {
                String parentDir = currentFile.getParent();
                if (!StringUtils.isBlank((String)parentDir) && new File(parentDir).exists()) {
                    executableFileNameEditor.setFilterPath(new File(parentDir));
                    System.out.println("parent dir  " + parentDir);
                }
            }
        }
    }

    public void updateAllTestButtonStatus(boolean showWarning) {
        for (String key : this.toolInfos.keySet()) {
            this.updateTestButtonStatus(key);
        }
    }

    private void updateTestButtonStatus(String toolName) {
        ToolInfo toolInfo = this.toolInfos.get(toolName);
        Button testButton = toolInfo.testButton;
        String toolExecutable = toolInfo.executableFileEditor.getStringValue();
        if (StringUtils.isBlank((String)toolExecutable)) {
            testButton.setEnabled(false);
            toolInfo.isValidLabel.setText("");
            toolInfo.isValidLabel.setForeground(Display.getCurrent().getSystemColor(2));
        } else {
            testButton.setEnabled(true);
        }
    }

    private void updateIsValidLabel(String keyIsValid, Label isValidLabel) {
        boolean isValid = this.preferenceStore.getBoolean(keyIsValid);
        if (isValid) {
            isValidLabel.setText("Tool executable was successfully tested");
            isValidLabel.setForeground(Display.getCurrent().getSystemColor(2));
        } else {
            isValidLabel.setText("Tool executable has to be tested");
            isValidLabel.setForeground(Display.getCurrent().getSystemColor(3));
        }
        isValidLabel.pack();
    }

    private class ToolInfo {
        String toolName;
        FileFieldEditor executableFileEditor;
        Button testButton;
        Label isValidLabel;
        String isValidKey;

        private ToolInfo() {
        }
    }
}

