/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.preferences.debug;

import eu.fbk.tools.adapter.ui.ToolConsoleFactory;
import eu.fbk.tools.adapter.ui.preferences.CommonPreferencePage;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class DebugPreferencePage
extends CommonPreferencePage {
    public static String DEVELOPMENT_MODE_PROPERTY_NAME = "eu.fbk.tools.developmentMode";

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(4));
        Label label = new Label(composite, 0);
        label.setText("Workspace: " + Platform.getInstanceLocation().getURL().getPath());
        this.widgets.add(composite);
        composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(150, -1));
        String[][] levels = new String[][]{{"FATAL", "FATAL"}, {"ERROR", "ERROR"}, {"WARNING", "WARN"}, {"INFO", "INFO"}, {"DEBUG", "DEBUG"}, {"TRACE", "TRACE"}, {"ALL", "ALL"}};
        this.addField((FieldEditor)new RadioGroupFieldEditor("debug.logLevel", "Log Level", 1, levels, composite, true));
        this.widgets.add(composite);
        composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(400, -1));
        this.addField((FieldEditor)new BooleanFieldEditor("debug.showConsole", "Show Console", composite));
        BooleanFieldEditor monolithicCheck = new BooleanFieldEditor("debug.developmentMode", "Development Mode", composite);
        monolithicCheck.getDescriptionControl(composite).setToolTipText("Enable development mode functionalities.\nFor debug purpose only.");
        this.addField((FieldEditor)monolithicCheck);
        this.widgets.add(composite);
    }

    @Override
    public boolean performOk() {
        if (super.performOk()) {
            String level = this.getPreferenceStore().getString("debug.logLevel");
            Logger.getLogger((String)"eu.fbk.tools").setLevel(Level.toLevel((String)level));
            LogManager.getRootLogger().setLevel(Level.toLevel((String)level));
            String enableMonolithicCheck = this.getPreferenceStore().getBoolean("debug.developmentMode") ? "true" : "false";
            System.setProperty(DEVELOPMENT_MODE_PROPERTY_NAME, enableMonolithicCheck);
            if (this.getPreferenceStore().getBoolean("debug.showConsole")) {
                new ToolConsoleFactory().showConsole();
            } else {
                new ToolConsoleFactory().closeConsole();
            }
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench) {
    }
}

