/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.safety;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ui.commands.safety.AbstractSafetyAnalysisCommand;
import eu.fbk.tools.adapter.xsap.ExtendModel;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendModelCommand
extends AbstractSafetyAnalysisCommand {
    private static final Logger logger = LoggerFactory.getLogger(ExtendModelCommand.class);
    private ExtendModel function;
    protected String faultExtensionsFileName = null;
    protected String faultModesFileName = null;

    public ExtendModelCommand() {
        super("Extend Model");
    }

    @Override
    protected void initialize() {
        this.function = new ExtendModel();
        this.faultExtensionsFileName = null;
        this.faultModesFileName = null;
        super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.faultExtensionsFileName = this.getFileNameParameter(event, "fault_extensions", "xml", "Choose the fault extension file");
        if (StringUtils.isBlank((CharSequence)this.faultExtensionsFileName)) {
            this.displayError(this.getCommandDescription(), "Fault extensions have not been specified, can't execute the command.");
            logger.error("Missing fault extensions");
            return false;
        }
        logger.debug("Set fault extensions file to " + this.faultExtensionsFileName);
        this.function.setBehaviourModel(FileUtils.stringToURI((String)this.behaviourFileName));
        this.function.setFaultExtensions(FileUtils.stringToURI((String)this.faultExtensionsFileName));
        this.faultModesFileName = event.getParameter("fault_modes");
        if (this.faultModesFileName != null) {
            this.faultModesFileName = this.faultModesFileName.replace("\"", "");
            this.function.setFaultModes(FileUtils.stringToURI((String)this.faultModesFileName));
            logger.debug("Set fault modes file to " + this.faultModesFileName);
        }
        return true;
    }
}

