/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.contract;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ocra.CheckContractRefinement;
import eu.fbk.tools.adapter.ocra.OcraFunction;
import eu.fbk.tools.adapter.ui.commands.contract.AbstractCheckContractCommand;
import eu.fbk.tools.adapter.ui.dialog.contract.ContractRefinementParametersDialog;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckContractRefinementCommand
extends AbstractCheckContractCommand {
    private static final Logger logger = LoggerFactory.getLogger(CheckContractRefinementCommand.class);
    private CheckContractRefinement function;

    public CheckContractRefinementCommand() {
        super("Check Contract Refinement");
    }

    @Override
    protected void initialize() {
        this.function = new CheckContractRefinement();
        super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        String algorithmType;
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setContractModel(FileUtils.stringToURI((String)this.contractFileName));
        this.function.setTimeModel(this.timeModel);
        this.function.setContractName(event.getParameter("contract_name"));
        if (this.function.getContractName() != null) {
            logger.debug("Set contract name to " + this.function.getContractName());
        }
        if (!StringUtils.isBlank((CharSequence)(algorithmType = event.getParameter("algorithm_type")))) {
            try {
                this.function.setAlgorithmType(OcraFunction.AlgorithmType.valueOf((String)algorithmType));
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid algorithm type parameter value, can't execute the command.");
                logger.error("Invalid algorithm type parameter value: " + algorithmType);
                return false;
            }
        }
        if (this.function.getAlgorithmType() != null) {
            logger.debug("Set algorithm type to " + this.function.getAlgorithmType().name());
        }
        if (this.isDevelopmentModeEnabled()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ContractRefinementParametersDialog dialog = new ContractRefinementParametersDialog(CheckContractRefinementCommand.this.activeShell, CheckContractRefinementCommand.this.function, CheckContractRefinementCommand.this.asyncExecution);
                    dialog.open();
                    if (dialog.goAhead()) {
                        CheckContractRefinementCommand.this.asyncExecution = dialog.getAsyncExecution();
                    }
                }
            };
            display.syncExec(runnable);
        }
        return true;
    }
}

