/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.contract;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ocra.CheckContractImplementation;
import eu.fbk.tools.adapter.ocra.OcraFunction;
import eu.fbk.tools.adapter.ui.commands.contract.AbstractCheckContractCommand;
import eu.fbk.tools.adapter.ui.dialog.contract.ContractImplementationParametersDialog;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckContractImplementationCommand
extends AbstractCheckContractCommand {
    private static final Logger logger = LoggerFactory.getLogger(CheckContractImplementationCommand.class);
    private CheckContractImplementation function;
    protected String behaviourFileName = null;

    public CheckContractImplementationCommand() {
        super("Check Contract Implementation");
    }

    @Override
    protected void initialize() {
        this.function = new CheckContractImplementation();
        this.behaviourFileName = null;
        super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        String oldModelFormat;
        String componentName;
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setContractModel(FileUtils.stringToURI((String)this.contractFileName));
        this.behaviourFileName = this.getFileNameParameter(event, "behaviour_model", "smv", "Choose the behaviour model file");
        if (StringUtils.isBlank((CharSequence)this.behaviourFileName)) {
            this.displayError(this.getCommandDescription(), "Behaviour model has not been specified, can't execute the command.");
            logger.error("Behaviour model has not been specified, can't execute the command.");
            return false;
        }
        logger.debug("Set behaviour model to " + this.behaviourFileName);
        this.function.setBehaviourModel(FileUtils.stringToURI((String)this.behaviourFileName));
        this.function.setTimeModel(this.timeModel);
        String algorithmType = event.getParameter("algorithm_type");
        if (!StringUtils.isBlank((CharSequence)algorithmType)) {
            try {
                this.function.setAlgorithmType(OcraFunction.AlgorithmType.valueOf((String)algorithmType));
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid algorithm type parameter value, can't execute the command.");
                logger.error("Invalid algorithm type parameter value: " + algorithmType);
                return false;
            }
            logger.debug("Set algorithm type to " + this.function.getAlgorithmType().name());
        }
        this.function.setContractName(event.getParameter("contract_name"));
        if (this.function.getContractName() != null) {
            logger.debug("Set contract name to " + this.function.getContractName());
        }
        if (StringUtils.isBlank((CharSequence)(componentName = event.getParameter("component_name")))) {
            componentName = new File(this.contractFileName).getName().replace(".oss", "");
        }
        this.function.setComponentName(componentName);
        if (this.function.getComponentName() != null) {
            logger.debug("Set component name to " + this.function.getComponentName());
        }
        if (!StringUtils.isBlank((CharSequence)(oldModelFormat = event.getParameter("old_model_format")))) {
            try {
                this.function.setOldSmvFormat(Boolean.valueOf(oldModelFormat));
            }
            catch (Exception exception) {
                logger.error("Invalid old model parameter value: " + oldModelFormat);
            }
        }
        this.function.setBoundLength(Integer.valueOf(10));
        if (this.isDevelopmentModeEnabled()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ContractImplementationParametersDialog dialog = new ContractImplementationParametersDialog(CheckContractImplementationCommand.this.activeShell, CheckContractImplementationCommand.this.function, CheckContractImplementationCommand.this.asyncExecution);
                    dialog.open();
                    if (dialog.goAhead()) {
                        CheckContractImplementationCommand.this.asyncExecution = dialog.getAsyncExecution();
                    }
                }
            };
            display.syncExec(runnable);
        }
        return true;
    }
}

