/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.contract;

import eu.fbk.tools.adapter.ocra.OcraFunction;
import eu.fbk.tools.adapter.ui.commands.AbstractToolCommand;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCheckContractCommand
extends AbstractToolCommand {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCheckContractCommand.class);
    protected String contractFileName = null;
    protected OcraFunction.TimeModel timeModel = null;

    public AbstractCheckContractCommand(String commandDescription) {
        super("OCRA", commandDescription, "tools.ocra.executable", "tools.ocra.timeout");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.contractFileName = null;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.contractFileName = this.getFileNameParameter(event, "contract_model", "oss", "Choose the contract model file");
        if (StringUtils.isBlank((CharSequence)this.contractFileName)) {
            this.displayError(this.getCommandDescription(), "Contract model has not been specified, can't execute the command.");
            logger.error("Missing mandatory contract model");
            return false;
        }
        logger.debug("Set contract model to " + this.contractFileName);
        this.timeModel = null;
        String timeModelParameter = event.getParameter("time_model");
        if (!StringUtils.isBlank((CharSequence)timeModelParameter)) {
            try {
                this.timeModel = OcraFunction.TimeModel.valueOf((String)timeModelParameter);
                logger.debug("Set time model to: " + this.timeModel.name());
            }
            catch (Exception e) {
                this.displayError(this.getCommandDescription(), "Internal error: unexpected value of time_model parameter, can't execute the command.");
                logger.error("Unexpected value of time_model parameter: " + timeModelParameter + " . Allowed values are: " + this.timeModel.toString(), (Throwable)e);
                return false;
            }
        }
        if (this.timeModel == null) {
            this.timeModel = OcraFunction.TimeModel.discrete;
            logger.debug("Set time model to default value: " + this.timeModel.name());
        }
        return true;
    }
}

