/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.diagram;

import eu.fbk.eclipse.standardtools.diagram.ComponentDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ContractFtaResultDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ContractImplementationResultDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ContractRefinementResultDescriptor;
import eu.fbk.eclipse.standardtools.diagram.DiagramDescriptor;
import eu.fbk.eclipse.standardtools.diagram.FmeaResultDescriptor;
import eu.fbk.eclipse.standardtools.diagram.FtaResultDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ModelCheckingResultDescriptor;
import eu.fbk.eclipse.standardtools.diagram.PropertyValidationResultDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class ContainerDescriptor {
    public String name;
    public String format;
    public String description;
    public ComponentDescriptor componentDescriptor;
    public Map<String, String> specificationTag = new Hashtable<String, String>();
    public Map<String, String> specifications = new Hashtable<String, String>();
    public List<ContainerDescriptor> children = new ArrayList<ContainerDescriptor>();
    public List<DiagramDescriptor> diagrams = new ArrayList<DiagramDescriptor>();
    public List<FmeaResultDescriptor> fmeaResultDescriptors = new ArrayList<FmeaResultDescriptor>();
    public List<FtaResultDescriptor> ftaResultDescriptors = new ArrayList<FtaResultDescriptor>();
    public List<ContractFtaResultDescriptor> contractFtaResultDescriptors = new ArrayList<ContractFtaResultDescriptor>();
    public List<ContractRefinementResultDescriptor> contractRefinementResultDescriptors = new ArrayList<ContractRefinementResultDescriptor>();
    public List<ContractImplementationResultDescriptor> contractImplementationResultDescriptors = new ArrayList<ContractImplementationResultDescriptor>();
    public List<PropertyValidationResultDescriptor> propertyValidationResultDescriptors = new ArrayList<PropertyValidationResultDescriptor>();
    public List<PropertyValidationResultDescriptor> contractPropertyValidationResultDescriptors = new ArrayList<PropertyValidationResultDescriptor>();
    public List<ModelCheckingResultDescriptor> modelCheckingResultDescriptors = new ArrayList<ModelCheckingResultDescriptor>();
    public boolean showAnalysisResults;

    public void createNewSpecification(String key, String tag) {
        this.specificationTag.put(key, tag);
    }

    public List<ContainerDescriptor> getFlatDescriptorList() {
        ArrayList<ContainerDescriptor> descriptors = new ArrayList<ContainerDescriptor>();
        descriptors.add(this);
        return this.getFlatDescriptorList(this, descriptors);
    }

    private List<ContainerDescriptor> getFlatDescriptorList(ContainerDescriptor parentDescriptor, List<ContainerDescriptor> descriptors) {
        for (ContainerDescriptor descriptor : parentDescriptor.children) {
            descriptors.add(descriptor);
            this.getFlatDescriptorList(descriptor, descriptors);
        }
        return descriptors;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> containerDescriptorMap = new HashMap<String, Object>();
        containerDescriptorMap.put("name", this.name);
        containerDescriptorMap.put("children", this.getRecursivelyContainerDescriptors(this));
        containerDescriptorMap.put("diagrams", this.getRecursivelyDiagramDescriptors(this));
        containerDescriptorMap.put("fmeaResults", this.getFmeaResultDescriptors(this));
        containerDescriptorMap.put("ftaResults", this.getFtaResultDescriptors(this));
        containerDescriptorMap.put("contractFtaResults", this.getContractFtaResultDescriptors(this));
        containerDescriptorMap.put("contractRefinementResults", this.getContractRefinementResultDescriptors(this));
        containerDescriptorMap.put("contractImplementationResults", this.getContractImplementationResultDescriptors(this));
        containerDescriptorMap.put("propertyValidationResults", this.getPropertyValidationResultDescriptors(this));
        containerDescriptorMap.put("contractPropertyValidationResults", this.getContractPropertyValidationResultDescriptors(this));
        containerDescriptorMap.put("modelCheckingResults", this.getModelCheckingResultDescriptors(this));
        if (this.componentDescriptor != null) {
            containerDescriptorMap.put("component", this.componentDescriptor.serialize());
        }
        for (String specificationKey : this.specifications.keySet()) {
            String tag = this.specificationTag.get(specificationKey);
            String specification = this.specifications.get(specificationKey);
            containerDescriptorMap.put(tag, specification);
        }
        if (this.showAnalysisResults) {
            containerDescriptorMap.put("showAnalysisResults", "true");
        }
        return containerDescriptorMap;
    }

    private List<Object> getRecursivelyDiagramDescriptors(ContainerDescriptor parentDescriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        for (DiagramDescriptor descriptor : parentDescriptor.diagrams) {
            descriptors.add(descriptor.serialize());
        }
        return descriptors;
    }

    private List<Object> getRecursivelyContainerDescriptors(ContainerDescriptor parentDescriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        for (ContainerDescriptor descriptor : parentDescriptor.children) {
            descriptors.add(descriptor.serialize());
        }
        return descriptors;
    }

    private List<Object> getFmeaResultDescriptors(ContainerDescriptor parentDescriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        for (FmeaResultDescriptor descriptor : parentDescriptor.fmeaResultDescriptors) {
            if (descriptor == null) continue;
            descriptors.add(descriptor.serialize());
        }
        return descriptors;
    }

    private List<Object> getFtaResultDescriptors(ContainerDescriptor parentDescriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        for (FtaResultDescriptor descriptor : parentDescriptor.ftaResultDescriptors) {
            if (descriptor == null) continue;
            descriptors.add(descriptor.serialize());
        }
        return descriptors;
    }

    private List<Object> getContractFtaResultDescriptors(ContainerDescriptor parentDescriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        for (ContractFtaResultDescriptor descriptor : parentDescriptor.contractFtaResultDescriptors) {
            if (descriptor == null) continue;
            descriptors.add(descriptor.serialize());
        }
        return descriptors;
    }

    private List<Object> getContractRefinementResultDescriptors(ContainerDescriptor parentDescriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        for (ContractRefinementResultDescriptor descriptor : parentDescriptor.contractRefinementResultDescriptors) {
            if (descriptor == null) continue;
            descriptors.add(descriptor.serialize());
        }
        return descriptors;
    }

    private List<Object> getContractImplementationResultDescriptors(ContainerDescriptor parentDescriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        for (ContractImplementationResultDescriptor descriptor : parentDescriptor.contractImplementationResultDescriptors) {
            if (descriptor == null) continue;
            descriptors.add(descriptor.serialize());
        }
        return descriptors;
    }

    private List<Object> getPropertyValidationResultDescriptors(ContainerDescriptor parentDescriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        for (PropertyValidationResultDescriptor descriptor : parentDescriptor.propertyValidationResultDescriptors) {
            if (descriptor == null) continue;
            descriptors.add(descriptor.serialize());
        }
        return descriptors;
    }

    private List<Object> getContractPropertyValidationResultDescriptors(ContainerDescriptor parentDescriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        for (PropertyValidationResultDescriptor descriptor : parentDescriptor.contractPropertyValidationResultDescriptors) {
            if (descriptor == null) continue;
            descriptors.add(descriptor.serialize());
        }
        return descriptors;
    }

    private List<Object> getModelCheckingResultDescriptors(ContainerDescriptor parentDescriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        for (ModelCheckingResultDescriptor descriptor : parentDescriptor.modelCheckingResultDescriptors) {
            if (descriptor == null) continue;
            descriptors.add(descriptor.serialize());
        }
        return descriptors;
    }
}

