/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.resourcelistener;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.Bundle;
import org.polarsys.chess.core.resourcelistener.SelectionListenerExtra;

public class SelectionListenerManager
extends SelectionListenerExtra {
    private Hashtable<String, SelectionListenerExtra> listenerRegistry = new Hashtable();
    private String LISTENERID_EXTENSION_ID = "org.polarsys.chess.selectionListener";
    private String NAME_ID = "name";
    private String REALIZATION_ID = "realization";

    public SelectionListenerManager(ServicesRegistry serviceRegistry) {
        this.setRegistry(serviceRegistry);
        this.initializeListenerList();
    }

    private void initializeListenerList() {
        Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.LISTENERID_EXTENSION_ID);
        int i = 0;
        while (i < configElements.length) {
            this.inializeOneRule(configElements[i]);
            ++i;
        }
    }

    private void inializeOneRule(IConfigurationElement element) {
        String listenerName = element.getAttribute(this.NAME_ID);
        try {
            SelectionListenerExtra listener = (SelectionListenerExtra)SelectionListenerManager.createExtension(element, element.getAttribute(this.REALIZATION_ID));
            listener.setRegistry(this.getRegistry());
            this.listenerRegistry.put(listenerName, listener);
        }
        catch (Exception exception) {}
    }

    private static Object createExtension(IConfigurationElement element, String classAttribute) throws Exception {
        try {
            Bundle extensionBundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
            Class clazz = extensionBundle.loadClass(classAttribute);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception e) {
            throw new Exception("unable to create Extension " + e);
        }
    }

    public String toString() {
        String out = "ModelListener: \n";
        Enumeration<String> keyenum = this.listenerRegistry.keys();
        while (keyenum.hasMoreElements()) {
            String aKey = keyenum.nextElement();
            out = String.valueOf(out) + "- " + aKey + " (" + this.listenerRegistry.get(aKey).toString() + ")\n";
        }
        return out;
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Enumeration<SelectionListenerExtra> listenersEnum = this.listenerRegistry.elements();
        while (listenersEnum.hasMoreElements()) {
            listenersEnum.nextElement().selectionChanged(part, selection);
        }
    }
}

