/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.c.tests;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.inject.Inject;
import eu.fbk.tools.editor.c.c.TranslationUnit;
import eu.fbk.tools.editor.c.tests.CInjectorProvider;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.testing.InjectWith;
import org.eclipse.xtext.testing.XtextRunner;
import org.eclipse.xtext.testing.util.ParseHelper;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=CInjectorProvider.class)
public class CParsingTest {
    @Inject
    private ParseHelper<TranslationUnit> parseHelper;
    @Inject
    private ValidationTestHelper validationHelper;
    @Inject
    private ISerializer serializer;
    @Rule
    public ErrorCollector collector = new ErrorCollector();

    @Before
    public void beforeTest() {
    }

    @Test(timeout=300000L)
    public void loadModel() {
        try {
            String userDir = System.getProperty("user.dir");
            String resourceDir = String.valueOf(userDir) + "/resources";
            File folder = new File(resourceDir);
            Object[] listOfFiles = folder.listFiles();
            Arrays.sort(listOfFiles);
            int files = listOfFiles.length;
            System.out.println("Found " + Integer.valueOf(files) + " models to be tested");
            int i = 1;
            Object[] objectArray = listOfFiles;
            int n = listOfFiles.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                String txt = Files.toString((File)file, (Charset)Charsets.UTF_8);
                TranslationUnit model = (TranslationUnit)this.parseHelper.parse((CharSequence)txt);
                String _name = ((File)file).getName();
                String _plus = "[" + Integer.valueOf(i) + "/" + Integer.valueOf(files) + "]" + "Processing model: " + _name;
                System.out.println(_plus);
                ++i;
                try {
                    String _name_1 = ((File)file).getName();
                    String _plus_1 = String.valueOf(_name_1) + " : ";
                    String _plus_2 = String.valueOf(_plus_1) + " parse failed";
                    Assert.assertNotNull((String)_plus_2, (Object)model);
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable t = _t;
                        this.collector.addError(t);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                if (model != null) {
                    boolean _greaterThan;
                    List issues = this.validationHelper.validate((EObject)model);
                    int _length = ((Object[])Conversions.unwrapArray((Object)issues, Object.class)).length;
                    boolean bl = _greaterThan = _length > 0;
                    if (_greaterThan) {
                        for (Issue issue : issues) {
                            try {
                                String _name_2 = ((File)file).getName();
                                String _plus_3 = String.valueOf(_name_2) + " : ";
                                String _string = issue.toString();
                                String _plus_4 = String.valueOf(_plus_3) + _string;
                                Assert.fail((String)_plus_4);
                            }
                            catch (Throwable _t_1) {
                                if (_t_1 instanceof Throwable) {
                                    Throwable t_1 = _t_1;
                                    this.collector.addError(t_1);
                                    continue;
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t_1);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

