/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationTemplate;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class ViewpointQuery {
    private Viewpoint vp;

    public ViewpointQuery(Viewpoint vp) {
        this.vp = vp;
    }

    public Iterable<RepresentationDescription> getAllRepresentationDescriptions() {
        ArrayList representations = Lists.newArrayList();
        representations.addAll(this.vp.getOwnedRepresentations());
        for (RepresentationTemplate template : this.vp.getOwnedTemplates()) {
            representations.addAll(template.getOwnedRepresentations());
        }
        return representations;
    }

    public Iterable<RepresentationExtensionDescription> getAllRepresentationExtensionDescriptions() {
        ArrayList representations = Lists.newArrayList();
        representations.addAll(this.vp.getOwnedRepresentationExtensions());
        return representations;
    }

    public Option<URI> getViewpointURI() {
        Resource vpResource = this.vp.eResource();
        if (vpResource != null && vpResource.getURI().isPlatform()) {
            URI resourceURI = vpResource.getURI();
            String pluginId = resourceURI.segment(1);
            String uri = "viewpoint:/" + pluginId + "/" + this.vp.getName();
            return Options.newSome((Object)URI.createURI((String)uri));
        }
        return Options.newNone();
    }

    public boolean hasSameSiriusURI(Viewpoint other) {
        Preconditions.checkNotNull((Object)other);
        Option<URI> vpURI = this.getViewpointURI();
        Option<URI> otherURI = new ViewpointQuery(other).getViewpointURI();
        return vpURI.some() && otherURI.some() && ((URI)vpURI.get()).equals(otherURI.get());
    }

    public boolean handlesSemanticModelExtension(String ext) {
        Preconditions.checkNotNull((Object)ext);
        String supportedExtensions = StringUtil.isEmpty((String)this.vp.getModelFileExtension()) ? "*" : this.vp.getModelFileExtension().trim();
        String[] stringArray = supportedExtensions.split(" +");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String supported = stringArray[n2];
            if (this.matches(ext, supported.trim())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean matches(String ext, String supportedExtension) {
        if ("*".equals(supportedExtension)) {
            return true;
        }
        String semanticExtensionPattern = "*." + ext;
        return ext.equals(supportedExtension) || semanticExtensionPattern.equals(supportedExtension);
    }
}

