/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect.description;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.dialect.description.MultiLanguagesValidator;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.tools.api.interpreter.context.SiriusInterpreterContextFactory;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.AbstractVariable;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.JavaExtension;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ChangeContext;
import org.eclipse.sirius.viewpoint.description.tool.ContainerModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.For;
import org.eclipse.sirius.viewpoint.description.tool.If;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.tool.VariableContainer;
import org.eclipse.sirius.viewpoint.description.validation.ValidationPackage;

public abstract class AbstractInterpretedExpressionQuery
implements IInterpretedExpressionQuery {
    protected static final VariableType DSEMANTIC_DECORATOR = VariableType.fromString((String)"viewpoint.DSemanticDecorator");
    protected static final String SELF = "self";
    protected static final String VARIABLES_ANNOTATION_SOURCE = "http://www.eclipse.org/sirius/interpreted/expression/variables";
    protected static final char TYPE_DEFINTION_SEPARATOR = '|';
    protected static final String VARIABLE_TYPE_KEY = "type";
    protected EObject target;
    protected EStructuralFeature feature;
    protected Option<Collection<String>> targetDomainClass;
    protected Collection<EPackage> packagesToImport;
    protected Collection<String> dependencies;
    protected Map<String, VariableType> availableVariables;
    protected VariableType selfType;
    protected IInterpretedExpressionTargetSwitch targetSwitch;

    public AbstractInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        this.target = target;
        this.feature = feature;
        this.initializeTargetSwitch();
    }

    protected abstract void initializeTargetSwitch();

    @Override
    public Option<Collection<String>> getTargetDomainClasses() {
        if (this.targetDomainClass == null) {
            this.getAvailableVariables();
            if (this.selfType != null && this.selfType.hasDefinition()) {
                LinkedHashSet possibleTypes = Sets.newLinkedHashSet();
                for (TypeName typeName : this.selfType.getPossibleTypes()) {
                    possibleTypes.add(typeName.getCompleteName());
                }
                this.targetDomainClass = Options.fromNullable((Object)possibleTypes);
            } else {
                this.targetDomainClass = this.targetSwitch.doSwitch(this.target, this.feature != null);
            }
        }
        return this.targetDomainClass;
    }

    @Override
    public Collection<EPackage> getPackagesToImport() {
        if (this.packagesToImport == null) {
            this.packagesToImport = Sets.newLinkedHashSet();
            EObject representation = this.target.eContainer();
            while (representation != null && !(representation instanceof RepresentationDescription)) {
                representation = representation.eContainer();
            }
            if (representation != null) {
                if (((RepresentationDescription)representation).getMetamodel().isEmpty()) {
                    for (String nsURI : Sets.newLinkedHashSet((Iterable)EPackage.Registry.INSTANCE.keySet())) {
                        try {
                            this.packagesToImport.add(EPackage.Registry.INSTANCE.getEPackage(nsURI));
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    this.packagesToImport.addAll((Collection<EPackage>)((RepresentationDescription)representation).getMetamodel());
                }
            }
            this.packagesToImport.add((EPackage)EcorePackage.eINSTANCE);
            this.packagesToImport.add(ViewpointPackage.eINSTANCE);
            this.packagesToImport.add(DescriptionPackage.eINSTANCE);
            this.packagesToImport.add(ToolPackage.eINSTANCE);
            this.packagesToImport.add(ValidationPackage.eINSTANCE);
        }
        return this.packagesToImport;
    }

    @Override
    public Collection<String> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = Sets.newLinkedHashSet();
            if (this.target != null) {
                EObject vp = this.target;
                while (vp != null && !(vp instanceof Viewpoint)) {
                    vp = vp.eContainer();
                }
                if (vp != null) {
                    for (JavaExtension dep : ((Viewpoint)vp).getOwnedJavaExtensions()) {
                        if (StringUtil.isEmpty((String)dep.getQualifiedClassName())) continue;
                        this.dependencies.add(dep.getQualifiedClassName());
                    }
                }
            }
        }
        return this.dependencies;
    }

    @Override
    public Map<String, VariableType> getAvailableVariables() {
        Option<EObject> toolContext;
        if (this.availableVariables == null) {
            this.availableVariables = Maps.newLinkedHashMap();
        }
        if ((toolContext = this.getToolContext()).some()) {
            EObject operationContext = (EObject)toolContext.get();
            this.collectContextualVariableDefinitions(operationContext, this.target);
            if (operationContext instanceof ToolDescription) {
                this.availableVariables.put("containerView", DSEMANTIC_DECORATOR);
                IInterpreterContext iContext = SiriusInterpreterContextFactory.createInterpreterContext(operationContext, (EStructuralFeature)ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION);
                ValidationResult res = MultiLanguagesValidator.getInstance().validateExpression(iContext, ((ToolDescription)operationContext).getPrecondition());
                Map inferedTypes = res.getInferredVariableTypes(Boolean.TRUE);
                for (Map.Entry infered : inferedTypes.entrySet()) {
                    if (SELF.equals(infered.getKey())) {
                        this.changeSelfType((VariableType)infered.getValue());
                        continue;
                    }
                    this.availableVariables.put((String)infered.getKey(), (VariableType)infered.getValue());
                }
            }
            this.addVariablesFromToolContext(operationContext);
        }
        this.collectLocalVariablesDefinitions();
        if (this.target instanceof ToolDescription && this.feature == ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION) {
            this.availableVariables.put("containerView", DSEMANTIC_DECORATOR);
            this.availableVariables.put(((ToolDescription)this.target).getElement().getName(), VariableType.ANY_EOBJECT);
            this.availableVariables.put(((ToolDescription)this.target).getElementView().getName(), DSEMANTIC_DECORATOR);
        }
        if (ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__ELEMENTS_TO_SELECT.equals(this.feature)) {
            this.collectContextualVariableDefinitions(this.target, this.target);
            this.addVariablesFromToolContext(this.target);
            this.addVariablesFromCreateOperation(this.target);
        }
        return this.availableVariables;
    }

    protected void addVariablesFromToolContext(EObject toolContext) {
    }

    private void addVariablesFromCreateOperation(EObject toolContext) {
        TreeIterator eAllContents = toolContext.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            if (!(eObject instanceof ModelOperation)) continue;
            this.addVariableFromCreateOperation((ModelOperation)eObject);
        }
    }

    protected void addVariableFromCreateOperation(ModelOperation modelOperation) {
        if (modelOperation instanceof CreateInstance && !StringUtil.isEmpty((String)((CreateInstance)modelOperation).getVariableName())) {
            this.availableVariables.put(((CreateInstance)modelOperation).getVariableName(), VariableType.fromString((String)((CreateInstance)modelOperation).getTypeName()));
        }
    }

    protected Option<EObject> getToolContext() {
        EObject container;
        Option<EObject> found = Options.newNone();
        found = new EObjectQuery(this.target).getFirstAncestorOfType(ValidationPackage.eINSTANCE.getValidationRule());
        if (!found.some() && (found = new EObjectQuery(this.target).getFirstAncestorOfType(ToolPackage.eINSTANCE.getAbstractToolDescription())).some() && found.get() instanceof ExternalJavaAction && ((container = ((EObject)found.get()).eContainer()) instanceof ModelOperation || container instanceof InitialOperation)) {
            found = new EObjectQuery(container).getFirstAncestorOfType(ToolPackage.eINSTANCE.getAbstractToolDescription());
        }
        return found;
    }

    private void collectLocalVariablesDefinitions() {
        EAnnotation varAnnotations;
        if (this.feature != null && (varAnnotations = this.feature.getEAnnotation(VARIABLES_ANNOTATION_SOURCE)) != null) {
            for (String varName : varAnnotations.getDetails().keySet()) {
                String doc = (String)varAnnotations.getDetails().get((Object)varName);
                VariableType typeName = VariableType.ANY_EOBJECT;
                if (doc != null && doc.indexOf(124) != -1) {
                    typeName = VariableType.fromString((String)doc.substring(0, doc.indexOf(124)).trim());
                }
                if (this.availableVariables.containsKey(varName)) continue;
                this.availableVariables.put(varName, typeName);
            }
        }
    }

    private void collectContextualVariableDefinitions(EObject top, EObject bottom) {
        HashMap definitions = Maps.newHashMap();
        EObject context = bottom;
        while (context != null && context != top.eContainer()) {
            this.appendAllLocalVariableDefinitions(definitions, context);
            this.collectContextualVariableForOperation(context, definitions, bottom);
            if (context != top) {
                EObject sibling = this.precedingSibling(context);
                while (sibling != null) {
                    this.appendAllLocalVariableDefinitions(definitions, sibling);
                    sibling = this.precedingSibling(sibling);
                }
            }
            context = context.eContainer();
        }
        for (Map.Entry var : definitions.entrySet()) {
            this.availableVariables.put((String)var.getKey(), (VariableType)((Collection)var.getValue()).iterator().next());
        }
    }

    protected void collectContextualVariableForOperation(EObject current, Map<String, Collection<VariableType>> definitions, EObject leaf) {
        ContainerModelOperation f;
        if (current != leaf) {
            VariableType returnTypes;
            ValidationResult res;
            IInterpreterContext iContext;
            if (current instanceof If) {
                If ifThen = (If)current;
                iContext = SiriusInterpreterContextFactory.createInterpreterContext(ifThen, (EStructuralFeature)ToolPackage.Literals.CHANGE_CONTEXT__BROWSE_EXPRESSION);
                res = MultiLanguagesValidator.getInstance().validateExpression(iContext, ifThen.getConditionExpression());
                Map inferedTypes = res.getInferredVariableTypes(Boolean.TRUE);
                for (Map.Entry infered : inferedTypes.entrySet()) {
                    if (SELF.equals(infered.getKey())) {
                        this.changeSelfType((VariableType)infered.getValue());
                        continue;
                    }
                    this.addDefinition(definitions, (String)infered.getKey(), (VariableType)infered.getValue());
                }
            }
            if (current instanceof ChangeContext) {
                f = (ChangeContext)current;
                iContext = SiriusInterpreterContextFactory.createInterpreterContext(f, (EStructuralFeature)ToolPackage.Literals.CHANGE_CONTEXT__BROWSE_EXPRESSION);
                res = MultiLanguagesValidator.getInstance().validateExpression(iContext, f.getBrowseExpression());
                returnTypes = res.getReturnTypes();
                this.changeSelfType(returnTypes);
            }
            if (current instanceof For) {
                f = (For)current;
                iContext = SiriusInterpreterContextFactory.createInterpreterContext(f, (EStructuralFeature)ToolPackage.Literals.FOR__EXPRESSION);
                res = MultiLanguagesValidator.getInstance().validateExpression(iContext, f.getExpression());
                returnTypes = res.getReturnTypes();
                this.changeSelfType(returnTypes);
                this.addDefinition(definitions, f.getIteratorName(), returnTypes);
            }
        }
        if (current instanceof CreateInstance) {
            f = (CreateInstance)current;
            this.changeSelfType(VariableType.fromString((String)f.getTypeName()));
        }
    }

    protected void changeSelfType(VariableType newSelfType) {
        if (this.selfType == null) {
            this.selfType = newSelfType;
        }
    }

    private EObject precedingSibling(EObject context) {
        Object sibling;
        EList childs;
        int contextPositionInContainingList;
        Object val;
        EObject container = context.eContainer();
        EStructuralFeature containingFeature = context.eContainingFeature();
        if (container != null && containingFeature != null && (val = container.eGet(containingFeature)) instanceof EList && (contextPositionInContainingList = (childs = (EList)val).indexOf((Object)context)) > 0 && (sibling = childs.get(contextPositionInContainingList - 1)) instanceof EObject) {
            return (EObject)sibling;
        }
        return null;
    }

    protected VariableType getVariableTypeName(AbstractVariable var) {
        Preconditions.checkNotNull((Object)var);
        Preconditions.checkNotNull((Object)var.eContainingFeature());
        VariableType typeName = VariableType.ANY_EOBJECT;
        EAnnotation varAnnotation = var.eContainingFeature().getEAnnotation(VARIABLES_ANNOTATION_SOURCE);
        if (varAnnotation != null && varAnnotation.getDetails().containsKey((Object)VARIABLE_TYPE_KEY)) {
            typeName = VariableType.fromString((String)((String)varAnnotation.getDetails().get((Object)VARIABLE_TYPE_KEY)));
        }
        return typeName;
    }

    protected void appendAllLocalVariableDefinitions(Map<String, Collection<VariableType>> definitions, EObject context) {
        if (context instanceof AbstractToolDescription) {
            for (AbstractVariable var : Iterables.filter((Iterable)AllContents.of((EObject)context, (boolean)false), AbstractVariable.class)) {
                this.addDefinition(definitions, var.getName(), this.getVariableTypeName(var));
            }
        }
        if (context instanceof VariableContainer) {
            for (AbstractVariable subVar : ((VariableContainer)context).getSubVariables()) {
                this.appendAllLocalVariableDefinitions(definitions, subVar);
            }
        }
        if (context instanceof AbstractVariable) {
            AbstractVariable var;
            var = (AbstractVariable)context;
            this.addDefinition(definitions, var.getName(), this.getVariableTypeName(var));
        }
        if (context instanceof CreateInstance) {
            CreateInstance ci = (CreateInstance)context;
            this.addDefinition(definitions, ci.getVariableName(), ci.getTypeName());
        }
    }

    protected void appendEditMaskVariables(EditMaskVariables mask, Map<String, Collection<VariableType>> definitions) {
        Pattern p = Pattern.compile("\\{\\d\\}");
        Matcher m = p.matcher(mask.getMask());
        while (m.find()) {
            String group = m.group();
            String index = group.substring(1, group.length() - 1);
            this.addDefinition(definitions, index, "String");
            this.addDefinition(definitions, "arg" + index, "String");
        }
    }

    protected void addDefinition(Map<String, Collection<VariableType>> definitions, String name, String value) {
        this.addDefinition(definitions, name, VariableType.fromString((String)value));
    }

    protected void addDefinition(Map<String, Collection<VariableType>> definitions, String name, VariableType type) {
        if (name != null) {
            ArrayList defs = definitions.get(name);
            if (defs == null) {
                defs = Lists.newArrayList();
                definitions.put(name, defs);
            }
            defs.add(type);
        }
    }
}

