/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwComputing;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ISA_Type implements Enumerator
{
    RISC(0, "RISC", "RISC"),
    CISC(1, "CISC", "CISC"),
    VLIW(2, "VLIW", "VLIW"),
    SIMD(3, "SIMD", "SIMD"),
    OTHER(4, "other", "other"),
    UNDEF(5, "undef", "undef");

    public static final int RISC_VALUE = 0;
    public static final int CISC_VALUE = 1;
    public static final int VLIW_VALUE = 2;
    public static final int SIMD_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    public static final int UNDEF_VALUE = 5;
    private static final ISA_Type[] VALUES_ARRAY;
    public static final List<ISA_Type> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ISA_Type[]{RISC, CISC, VLIW, SIMD, OTHER, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ISA_Type get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ISA_Type result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ISA_Type getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ISA_Type result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ISA_Type get(int value) {
        switch (value) {
            case 0: {
                return RISC;
            }
            case 1: {
                return CISC;
            }
            case 2: {
                return VLIW;
            }
            case 3: {
                return SIMD;
            }
            case 4: {
                return OTHER;
            }
            case 5: {
                return UNDEF;
            }
        }
        return null;
    }

    private ISA_Type(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

