/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.checkers.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.checkers.core.checkerManager.Checker;
import org.polarsys.chess.checkers.core.checkerManager.CheckerMessage;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;

public class NameDistance
extends Checker {
    private int threshold = 2;
    private Package systemViewPackage;
    private static final Logger logger = Logger.getLogger(NameDistance.class);
    private static final String checkerName = "NameDistance";

    public NameDistance() {
        super(checkerName, NameDistance.getTags());
    }

    public NameDistance(int priority) {
        super(checkerName, NameDistance.getTags(), priority);
    }

    public NameDistance(int priority, int threshold) {
        super(checkerName, NameDistance.getTags(), priority);
        this.setThreshold(threshold);
    }

    public NameDistance(Set<String> tags) {
        super(checkerName, tags);
    }

    public NameDistance(Set<String> tags, int priority) {
        super(checkerName, tags, priority);
    }

    public NameDistance(Set<String> tags, int priority, int threshold) {
        super(checkerName, tags, priority);
        this.setThreshold(threshold);
    }

    private static Set<String> getTags() {
        HashSet<String> tags = new HashSet<String>();
        tags.add("fast");
        tags.add("warnings");
        tags.add("errors");
        tags.add("sysml");
        return tags;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public List<CheckerMessage> check(IProgressMonitor monitor) throws Exception {
        ArrayList<CheckerMessage> messages = new ArrayList<CheckerMessage>();
        Collection blocks = null;
        try {
            blocks = EntityUtil.getInstance().getAllClasses(this.systemViewPackage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        monitor.beginTask(this.unifiedName, blocks.size());
        for (Class block : blocks) {
            messages.addAll(this.processBlock(block));
            if (monitor.isCanceled()) {
                throw new Exception("Checker interrupted");
            }
            monitor.worked(1);
        }
        return messages;
    }

    private List<CheckerMessage> processBlock(Class block) {
        EList<NamedElement> elements = this.filterElements(block);
        return this.processElements(elements);
    }

    protected EList<NamedElement> filterElements(Class block) {
        EList attributes = block.getOwnedAttributes();
        EList operations = block.getOwnedOperations();
        EList behaviors = block.getOwnedBehaviors();
        EList ports = block.getOwnedPorts();
        BasicEList elements = new BasicEList(attributes.size() + operations.size() + behaviors.size() + ports.size());
        elements.addAll((Collection)attributes);
        elements.addAll((Collection)operations);
        elements.addAll((Collection)behaviors);
        elements.addAll((Collection)ports);
        return elements;
    }

    private List<CheckerMessage> processElements(EList<NamedElement> elements) {
        ArrayList<CheckerMessage> messages = new ArrayList<CheckerMessage>();
        int i = 0;
        while (i < elements.size()) {
            NamedElement first = (NamedElement)elements.get(i);
            String firstName = this.normalizeName(first.getName());
            ArrayList<String> similarNames = new ArrayList<String>(2);
            int j = 0;
            while (j < elements.size()) {
                if (j != i) {
                    NamedElement second = (NamedElement)elements.get(j);
                    String secondName = this.normalizeName(second.getName());
                    int distance = NameDistance.levenshteinDistance(firstName, secondName);
                    logger.debug((Object)(String.valueOf(firstName) + " and " + secondName + " distance = " + distance));
                    if (distance == 0) {
                        String msg = this.equalsMsg(first, second);
                        messages.add(this.createMessage(msg, 2, (EObject)first, this.unifiedName));
                    }
                    if (distance <= this.threshold) {
                        similarNames.add(second.getName());
                    }
                }
                ++j;
            }
            if (similarNames.size() > 0) {
                String msg = this.similarMsg(first, similarNames);
                messages.add(this.createMessage(msg, 1, (EObject)first, this.unifiedName));
            }
            ++i;
        }
        return messages;
    }

    protected String equalsMsg(NamedElement first, NamedElement second) {
        return "The term '" + first.getName() + "' is equal to '" + second.getName() + "' in block '" + ((Class)first.getOwner()).getName() + "'";
    }

    protected String similarMsg(NamedElement first, ArrayList<String> similarNames) {
        return "The term '" + first.getName() + "' is very similar to '" + String.join((CharSequence)"' and '", similarNames) + "' in block '" + ((Class)first.getOwner()).getName() + "'";
    }

    private String normalizeName(String name) {
        return name.toLowerCase();
    }

    private static int levenshteinDistance(CharSequence lhs, CharSequence rhs) {
        int len0 = lhs.length() + 1;
        int len1 = rhs.length() + 1;
        int[] cost = new int[len0];
        int[] newcost = new int[len0];
        int i = 0;
        while (i < len0) {
            cost[i] = i;
            ++i;
        }
        int j = 1;
        while (j < len1) {
            newcost[0] = j;
            int i2 = 1;
            while (i2 < len0) {
                int match = lhs.charAt(i2 - 1) == rhs.charAt(j - 1) ? 0 : 1;
                int cost_replace = cost[i2 - 1] + match;
                int cost_insert = cost[i2] + 1;
                int cost_delete = newcost[i2 - 1] + 1;
                newcost[i2] = Math.min(Math.min(cost_insert, cost_delete), cost_replace);
                ++i2;
            }
            int[] swap = cost;
            cost = newcost;
            newcost = swap;
            ++j;
        }
        return cost[len0 - 1];
    }

    protected CheckerMessage createMessage(String msg, int severity, EObject element, String unifiedName) {
        return new CheckerMessage(msg, severity, element, unifiedName);
    }

    @Override
    public void init() throws Exception {
        this.systemViewPackage = EntityUtil.getInstance().getCurrentSystemView();
    }
}

