/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.checkers.core.checkerManager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.checkers.core.checkerManager.Checker;
import org.polarsys.chess.checkers.core.checkerManager.CheckerManager;

public class CheckersContainer {
    private static final Logger logger = Logger.getLogger(CheckersContainer.class);
    List<Checker> checkers = new ArrayList<Checker>();
    CheckerManager checkerManager;

    public CheckersContainer(CheckerManager checkerManager) {
        this.checkerManager = checkerManager;
        checkerManager.register(this);
    }

    public void run(Set<String> checkersTags) throws Exception {
        boolean isFirstChecker = true;
        for (Checker checker : this.checkers) {
            this.checkerManager.updateCheckerStatus(checker.unifiedName, false);
            if (!checker.belongsTo(checkersTags)) continue;
            logger.debug((Object)("run " + checker.getUnifiedName()));
            checker.asyncCheck(isFirstChecker);
            isFirstChecker = false;
        }
    }

    public void initSync(Set<String> checkersTags) throws Exception {
        for (Checker checker : this.checkers) {
            if (!checker.belongsTo(checkersTags)) continue;
            logger.debug((Object)("init " + checker.getUnifiedName()));
            checker.init();
        }
    }

    public List<Job> checkSync(Set<String> checkersTags, Package pkg) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (Checker checker : this.checkers) {
            this.checkerManager.updateCheckerStatus(checker.unifiedName, false);
            if (!checker.belongsTo(checkersTags)) continue;
            logger.debug((Object)("run " + checker.getUnifiedName()));
            jobs.add(checker.syncCheck(pkg));
        }
        return jobs;
    }

    public void register(Checker checker) {
        Optional<Checker> alreadyRegisteredChecker = this.find(this.checkers, checker.unifiedName);
        if (!alreadyRegisteredChecker.isPresent()) {
            logger.debug((Object)("register checker not present: " + checker.registerPriority));
            this.checkers.add(checker);
        } else if (alreadyRegisteredChecker.get().registerPriority < checker.registerPriority) {
            logger.debug((Object)("register checker already registered with priority: " + alreadyRegisteredChecker.get().registerPriority));
            logger.debug((Object)("checker to register with priority: " + checker.registerPriority));
            this.checkers.remove(alreadyRegisteredChecker.get());
            this.checkers.add(checker);
        }
    }

    public Optional<Checker> find(List<Checker> list, String name) {
        return list.stream().filter(o -> o.unifiedName.equals(name)).findFirst();
    }

    public Collection<? extends String> getTags() {
        HashSet<String> tags = new HashSet<String>();
        for (Checker checker : this.checkers) {
            tags.addAll(checker.getCheckerTags());
        }
        return tags;
    }
}

