/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.ui.internal.handlers;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.settings.PeakDetectorSettings;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.support.PeakProcessorSupport;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class DetectorByFileRunnable
implements IRunnableWithProgress {
    private IChromatogramSelectionMSD chromatogramSelection;
    private File file;

    public DetectorByFileRunnable(IChromatogramSelectionMSD chromatogramSelection, File file) {
        this.chromatogramSelection = chromatogramSelection;
        this.file = file;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Deconvolution (AMDIS) - Read ELU", -1);
            PeakProcessorSupport peakProcessorSupport = new PeakProcessorSupport();
            PeakDetectorSettings peakDetectorSettings = PreferenceSupplier.getPeakDetectorSettings();
            peakProcessorSupport.extractEluFileAndSetPeaks(this.chromatogramSelection, this.file, peakDetectorSettings, monitor);
            this.updateSelection();
        }
        finally {
            monitor.done();
        }
    }

    private void updateSelection() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DetectorByFileRunnable.this.chromatogramSelection instanceof ChromatogramSelectionMSD) {
                    ((ChromatogramSelectionMSD)DetectorByFileRunnable.this.chromatogramSelection).update(true);
                }
            }
        });
    }
}

