/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.core.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EMFHelper {
    private EMFHelper() {
    }

    public static String getIdentifier(EObject eObject) {
        if (eObject == null) {
            return "<null>";
        }
        if (eObject.eClass() == null) {
            return eObject.toString();
        }
        boolean success = false;
        EList attributes = eObject.eClass().getEAllAttributes();
        StringBuilder identifier = new StringBuilder();
        success = EMFHelper.tryGetNameAttribute(eObject, identifier);
        if (!success) {
            success = EMFHelper.tryGetAnyAttribute(eObject, (List<EAttribute>)attributes, identifier);
        }
        if (success) {
            identifier.append(" : ");
        }
        identifier.append(eObject.eClass().getName());
        return identifier.toString();
    }

    public static boolean tryGetAttribute(EObject eObject, EAttribute attribute, StringBuilder name) {
        boolean success = false;
        if (attribute != null) {
            try {
                Object obj = eObject.eGet((EStructuralFeature)attribute);
                if (obj != null) {
                    name.append(obj.toString());
                    success = true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return success;
    }

    public static boolean tryGetNameAttribute(EObject eObject, StringBuilder builder) {
        boolean success = false;
        for (EAttribute attribute : eObject.eClass().getEAllAttributes()) {
            if (!attribute.getName().equals("name")) continue;
            success = EMFHelper.tryGetAttribute(eObject, attribute, builder);
        }
        return success;
    }

    public static boolean tryGetAnyAttribute(EObject eObject, List<EAttribute> attributes, StringBuilder name) {
        boolean success = false;
        String stringName = "";
        for (EAttribute feature : attributes) {
            Object obj = eObject.eGet((EStructuralFeature)feature);
            if (obj instanceof String) {
                stringName = (String)obj;
            } else if (obj != null) {
                stringName = obj.toString();
            }
            if (stringName == null || stringName.equals("null")) continue;
            name.append(stringName);
            success = true;
            break;
        }
        return success;
    }

    public static List<EObject> linearize(Object object) {
        ArrayList<EObject> elementList = new ArrayList<EObject>();
        if (object instanceof EObject) {
            EObject root = (EObject)object;
            elementList.add(root);
            root.eAllContents().forEachRemaining(elementList::add);
        }
        return elementList;
    }

    public static String getNameAttribute(EObject eObject) {
        StringBuilder name = new StringBuilder();
        EMFHelper.tryGetNameAttribute(eObject, name);
        return name.toString();
    }

    public static boolean hasSameIdentifier(EObject first, EObject second) {
        return EMFHelper.getIdentifier(first).equals(EMFHelper.getIdentifier(second));
    }

    public static boolean isElementInList(List<EObject> list, EObject obj) {
        for (EObject next : list) {
            if (!EMFHelper.hasSameIdentifier(obj, next)) continue;
            return true;
        }
        return false;
    }
}

