/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.description.style.WorkspaceImageDescription;
import org.eclipse.sirius.diagram.ui.business.api.image.WorkspaceImageHelper;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.Style;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.model.handler.validation.CapellaDiagnostician;
import org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram.ImagePathRemoveResolver;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.OracleDefinition;
import org.polarsys.capella.test.validation.rules.ju.testcases.ValidationRulePartialTestCase;

public class Rule_I_46_IncorrectImagePath
extends ValidationRulePartialTestCase {
    private static final String INVALID_DNODE_1 = "_t384wPZTEe2yhKJMWgAjpw";
    private static final String INVALID_DNODE_2 = "_u2KNcPZTEe2yhKJMWgAjpw";
    private static final String SEMANTIC_NODE = "4b5920a3-ced9-4457-a669-db3d7a342f62";
    private int nodeCounter = 0;

    @Override
    protected List<String> getScopeDefinition() {
        return Arrays.asList(SEMANTIC_NODE);
    }

    @Override
    protected EClass getTargetedEClass() {
        return ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT;
    }

    @Override
    protected String getRuleID() {
        return "org.polarsys.capella.core.platform.sirius.sirius.validation.I_46";
    }

    @Override
    protected List<OracleDefinition> getOracleDefinitions() {
        return Arrays.asList(new OracleDefinition(SEMANTIC_NODE, 1));
    }

    private List<IMarker> checkDiagnostic(CapellaDiagnostician capellaDiagnostician, EObject modelToCheck, int expectedSeverity, Predicate<String> messagePredicate) {
        Diagnostic diagnostic = capellaDiagnostician.validate(modelToCheck);
        int severity = diagnostic.getSeverity();
        Rule_I_46_IncorrectImagePath.assertEquals((String)"Bad diagnostic severity", (int)expectedSeverity, (int)severity);
        List children = diagnostic.getChildren();
        Rule_I_46_IncorrectImagePath.assertEquals((String)"Bad diagnostic children number", (int)2, (int)children.size());
        IFile resourceFile = EcoreUtil2.getFile((Resource)modelToCheck.eResource());
        List<IMarker> result = children.stream().map(error -> {
            Rule_I_46_IncorrectImagePath.assertEquals((String)"Bad diagnostic severity", (int)expectedSeverity, (int)error.getSeverity());
            Rule_I_46_IncorrectImagePath.assertTrue((String)"Bad diagnotic message", (boolean)messagePredicate.test(error.getMessage()));
            return LightMarkerRegistry.getInstance().createMarker((IResource)resourceFile, error, "org.polarsys.capella.core.validation.markers");
        }).filter(marker -> marker != null).collect(Collectors.toList());
        return result;
    }

    @Override
    protected IStatus testCheckQuickFix(List<IMarker> markers) {
        for (IMarker marker : markers) {
            if (!this.getCheckQuickFix() || marker == null) continue;
            ImagePathRemoveResolver imagePathRemoveResolver = new ImagePathRemoveResolver();
            imagePathRemoveResolver.run(marker);
            EObject genericElement = (EObject)MarkerViewHelper.getModelElementsFromMarker((IMarker)marker).get(0);
            Rule_I_46_IncorrectImagePath.assertTrue((boolean)(genericElement instanceof AbstractDNode));
            AbstractDNode node = (AbstractDNode)genericElement;
            boolean mustBeWSI = node.getStyle().getDescription() instanceof WorkspaceImageDescription;
            if (mustBeWSI) {
                if (node.getStyle() instanceof WorkspaceImage) continue;
                return Status.error((String)"The I_46 Resolver has failed (must be workspace image)");
            }
            if (!(node.getStyle() instanceof WorkspaceImage)) continue;
            return Status.error((String)"The I_46 Resolver has failed (must not be workspace image)");
        }
        return Status.OK_STATUS;
    }

    @Override
    public void test() throws Exception {
        CapellaDiagnostician capellaDiagnostician = new CapellaDiagnostician(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory(), (IProgressMonitor)new NullProgressMonitor());
        CapellaModel model = this.getTestModel(this.getRequiredTestModel());
        CapellaElement diagramToCheck = this.prepareWorkspaceImage(model);
        EMFModelValidationPreferences.setConstraintDisabled((String)this.getRuleID(), (boolean)false);
        List<IMarker> marker = this.checkDiagnostic(capellaDiagnostician, (EObject)diagramToCheck, 4, message -> message.contains("can not be found for the diagram element"));
        if (this.getCheckQuickFix() && marker != null) {
            IStatus status = this.testCheckQuickFix(marker);
            Rule_I_46_IncorrectImagePath.assertTrue((String)status.getMessage(), (boolean)status.isOK());
        }
        EMFModelValidationPreferences.setConstraintDisabled((String)this.getRuleID(), (boolean)EMFModelValidationPreferences.isConstraintDisabledByDefault((String)this.getRuleID()));
    }

    private Stream<EObject> getInvalidElement(DView view) {
        DViewQuery query = new DViewQuery(view);
        Iterator found = query.getAllContentInRepresentations(eobject -> {
            String id = IdManager.getInstance().getId(eobject);
            return id.equals(INVALID_DNODE_1) || id.equals(INVALID_DNODE_2);
        });
        ArrayList result = new ArrayList();
        found.forEachRemaining(result::add);
        return result.stream();
    }

    private void updateStyleToInvalidImage(AbstractDNode dNode) {
        Style style = dNode.getStyle();
        if (style instanceof BasicLabelStyle) {
            BasicLabelStyle labelStyle = (BasicLabelStyle)style;
            WorkspaceImageHelper.INSTANCE.updateStyle(labelStyle, "file:/C:/INVALID/PATH/11_Images/circle_ws2.png");
        } else {
            Rule_I_46_IncorrectImagePath.fail((String)"No label style for node of test");
        }
    }

    private AbstractDNode countElements(AbstractDNode dNode) {
        ++this.nodeCounter;
        return dNode;
    }

    private CapellaElement prepareWorkspaceImage(CapellaModel model) {
        Session session = this.getSessionForTestModel(this.getRequiredTestModel());
        this.nodeCounter = 0;
        session.getOwnedViews().stream().flatMap(this::getInvalidElement).filter(AbstractDNode.class::isInstance).map(AbstractDNode.class::cast).map(this::countElements).forEach(this::updateStyleToInvalidImage);
        Rule_I_46_IncorrectImagePath.assertEquals((String)"Expected node _t384wPZTEe2yhKJMWgAjpw and _u2KNcPZTEe2yhKJMWgAjpw in aird", (int)2, (int)this.nodeCounter);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        CapellaElement element = (CapellaElement)IdManager.getInstance().getEObject(SEMANTIC_NODE, (IScope)scope);
        return element;
    }

    @Override
    protected String getRequiredTestModel() {
        return "exchange-item-instance-and-part-model";
    }

    @Override
    protected boolean getCheckQuickFix() {
        return true;
    }
}

