/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.i;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.test.validation.rules.ju.testcases.i.Rule_I37_38;

public class Rule_I_37_38_ComponentExchange
extends Rule_I37_38 {
    LogicalComponent lc1;
    LogicalComponent lc2;
    ComponentExchange ce;
    LogicalComponent libraryRootComponent;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.executeCommand(() -> {
            LogicalComponent rootLC = (LogicalComponent)this.projectSkeleton.getLogicalArchitecture().getSystem();
            this.lc1 = LaFactory.eINSTANCE.createLogicalComponent();
            rootLC.getOwnedLogicalComponents().add((Object)this.lc1);
            CapellaElementExt.creationService((EObject)this.lc1);
            this.lc2 = LaFactory.eINSTANCE.createLogicalComponent();
            this.lc2 = LaFactory.eINSTANCE.createLogicalComponent();
            rootLC.getOwnedLogicalComponents().add((Object)this.lc2);
            CapellaElementExt.creationService((EObject)this.lc2);
            Part sourcePart = (Part)this.lc1.getAbstractTypedElements().iterator().next();
            Part targetPart = (Part)this.lc2.getAbstractTypedElements().iterator().next();
            this.ce = ComponentExchangeExt.createComponentExchange((Part)sourcePart, null, (Part)targetPart, null, null, null, null, null, null, (boolean)false);
            this.libraryRootComponent = (LogicalComponent)this.librarySkeleton.getLogicalArchitecture().getSystem();
        });
    }

    public void test() throws Exception {
        this.expectRollback(() -> this.libraryRootComponent.getOwnedLogicalComponents().add((Object)this.lc1), "'C 1' cannot reference moved element 'CP 1' via 'source'");
        this.expectRollback(() -> this.libraryRootComponent.getOwnedLogicalComponents().add((Object)this.lc2), "'C 1' cannot reference moved element 'CP 1' via 'target'");
        this.expectRollback(() -> {
            this.libraryRootComponent.getOwnedLogicalComponents().add((Object)this.lc1);
            this.libraryRootComponent.getOwnedComponentExchanges().add((Object)this.ce);
        }, "'C 1' cannot reference moved element 'CP 1' via 'target'");
        this.expectRollback(() -> {
            this.libraryRootComponent.getOwnedLogicalComponents().add((Object)this.lc2);
            this.libraryRootComponent.getOwnedComponentExchanges().add((Object)this.ce);
        }, "'C 1' cannot reference moved element 'CP 1' via 'source'");
        this.expectNoRollback(() -> {
            this.libraryRootComponent.getOwnedLogicalComponents().add((Object)this.lc1);
            this.libraryRootComponent.getOwnedLogicalComponents().add((Object)this.lc2);
            this.libraryRootComponent.getOwnedComponentExchanges().add((Object)this.ce);
        });
    }
}

