/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.dcom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.test.framework.api.OracleDefinition;
import org.polarsys.capella.test.validation.rules.ju.testcases.ValidationRulePartialTestCase;

public class Rule_DCOM_21
extends ValidationRulePartialTestCase {
    private final String PREFIX_OK = "ok_";
    private final String PREFIX_FAIL = "fail_";
    List<FunctionPort> okPorts = new ArrayList<FunctionPort>();
    List<FunctionPort> failPorts = new ArrayList<FunctionPort>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        CapellaModel model = this.getTestModel(this.getRequiredTestModel());
        TransactionalEditingDomain domain = model.getEditingDomain();
        Project project = model.getProject(domain);
        TreeIterator it = project.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof FunctionPort)) continue;
            if (((FunctionPort)next).getName().startsWith("ok_")) {
                this.okPorts.add((FunctionPort)next);
                continue;
            }
            if (!((FunctionPort)next).getName().startsWith("fail_")) continue;
            this.failPorts.add((FunctionPort)next);
        }
    }

    @Override
    public void test() throws Exception {
        Rule_DCOM_21.assertFalse((boolean)this.okPorts.isEmpty());
        Rule_DCOM_21.assertFalse((boolean)this.failPorts.isEmpty());
        super.test();
    }

    @Override
    protected List<String> getScopeDefinition() {
        ArrayList<String> result = new ArrayList<String>();
        for (FunctionPort p : this.okPorts) {
            result.add(p.getId());
        }
        for (FunctionPort p : this.failPorts) {
            result.add(p.getId());
        }
        return result;
    }

    @Override
    protected String getRequiredTestModel() {
        return "testUnusedExchangeItems";
    }

    @Override
    protected EClass getTargetedEClass() {
        return FaPackage.Literals.FUNCTION_PORT;
    }

    @Override
    protected String getRuleID() {
        return "org.polarsys.capella.core.data.fa.validation.DCOM_21";
    }

    @Override
    protected List<OracleDefinition> getOracleDefinitions() {
        ArrayList<OracleDefinition> result = new ArrayList<OracleDefinition>();
        for (FunctionPort p : this.okPorts) {
            result.add(new OracleDefinition(p.getId(), 0));
        }
        for (FunctionPort p : this.failPorts) {
            result.add(new OracleDefinition(p.getId(), 1));
        }
        return result;
    }
}

