/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.emf.validation.service.IValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.polarsys.capella.test.framework.api.OracleDefinition;
import org.polarsys.capella.test.validation.rules.ju.testcases.ValidationRuleTestCase;

public abstract class AbstractSimpleValidationTest
extends ValidationRuleTestCase {
    @Override
    protected String getRequiredTestModel() {
        return null;
    }

    @Override
    protected String getRuleID() {
        return null;
    }

    @Override
    protected EClass getTargetedEClass() {
        return null;
    }

    @Override
    protected List<OracleDefinition> getOracleDefinitions() {
        return null;
    }

    @Override
    protected void setUp() throws Exception {
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
    }

    protected void ok(EObject e) {
        IStatus status = this.validate(e);
        AbstractSimpleValidationTest.assertTrue((String)status.getMessage(), (boolean)status.isOK());
    }

    protected void ko(EObject e) {
        IStatus status = this.validate(e);
        AbstractSimpleValidationTest.assertFalse((String)"Validator returned unexpected OK Status", (boolean)status.isOK());
    }

    protected abstract List<String> getRuleIDs();

    protected IStatus validate(EObject e) {
        ConstraintRegistry registry = ConstraintRegistry.getInstance();
        for (String ruleID : this.getRuleIDs()) {
            IConstraintDescriptor descriptor = registry.getDescriptor(ruleID);
            AbstractSimpleValidationTest.assertNotNull((String)("Did not find constraint with id " + ruleID + "in the constraint registry"), (Object)descriptor);
            descriptor.setEnabled(true);
        }
        IValidator<EObject> validator = this.getValidator();
        validator.addConstraintFilter(new IConstraintFilter(){

            public boolean accept(IConstraintDescriptor constraint_p, EObject target_p) {
                return AbstractSimpleValidationTest.this.getRuleIDs().contains(constraint_p.getId());
            }
        });
        return validator.validate((Object)e);
    }

    protected IValidator<EObject> getValidator() {
        return ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
    }
}

