/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.ui.semantic.browser.sirius.view.SiriusSemanticBrowserView;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class UnsynchronizedSemanticBrowser
extends BasicTestCase {
    public static String SA__DATAPKG = "1db63ef2-9d9d-4069-993a-0f6236f7454a";
    public static String SA__ROOTSF = "10ea7dd3-5406-4f0b-b083-95b3bce87a2f";
    private String projectTestName = "StatusLine";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectTestName);
    }

    protected SiriusSemanticBrowserView getSemanticBrowserViewer() {
        final SiriusSemanticBrowserView[] viewer = new SiriusSemanticBrowserView[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                viewer[0] = (SiriusSemanticBrowserView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
            }
        });
        return viewer[0];
    }

    public void test() throws Exception {
        CapellaModel model = this.getTestModel(this.projectTestName);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
        SiriusSemanticBrowserView semanticBrowserViewer = this.getSemanticBrowserViewer();
        EObject dataPkg = IdManager.getInstance().getEObject(SA__DATAPKG, (IScope)scope);
        semanticBrowserViewer.saveInput((Object)dataPkg, null);
        semanticBrowserViewer.deactivateListeningToPageSelectionEvents();
        EObject rootSF = IdManager.getInstance().getEObject(SA__ROOTSF, (IScope)scope);
        StructuredSelection fakeSelection = new StructuredSelection((Object)new String("NotNull"));
        semanticBrowserViewer.saveInput((Object)rootSF, (ISelection)fakeSelection);
        semanticBrowserViewer.setFocus();
        UnsynchronizedSemanticBrowser.assertTrue((String)"SB should still point to DataPkg since the synchronization has been deactivated", (semanticBrowserViewer.getCurrentViewer().getInput() == dataPkg ? 1 : 0) != 0);
        semanticBrowserViewer.activateListeningToPageSelectionEvents();
    }
}

