/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.core.ui.semantic.browser.sirius.view.SiriusSemanticBrowserView;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class StatusLineTestCase
extends BasicTestCase {
    public static String SA__DATAPKG = "1db63ef2-9d9d-4069-993a-0f6236f7454a";
    public static String SA__ROOTSF = "10ea7dd3-5406-4f0b-b083-95b3bce87a2f";
    private String projectTestName = "StatusLine";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectTestName);
    }

    protected CommonViewer getProjectExplorerViewer() {
        final CommonViewer[] viewer = new CommonViewer[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("capella.project.explorer");
                viewer[0] = ((CapellaCommonNavigator)part).getCommonViewer();
            }
        });
        return viewer[0];
    }

    protected SiriusSemanticBrowserView getSemanticBrowserViewer() {
        final SiriusSemanticBrowserView[] viewer = new SiriusSemanticBrowserView[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                viewer[0] = (SiriusSemanticBrowserView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
            }
        });
        return viewer[0];
    }

    protected String getStatusLineMessage(IStatusLineManager statusLineManager) throws Exception {
        Field field = statusLineManager.getClass().getDeclaredField("message");
        field.setAccessible(true);
        return (String)field.get(statusLineManager);
    }

    public void test() throws Exception {
        CapellaModel model = this.getTestModel(this.projectTestName);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        CommonViewer viewer = this.getProjectExplorerViewer();
        EObject dataPkg = IdManager.getInstance().getEObject(SA__DATAPKG, (IScope)scope);
        StructuredSelection dataPkgselection = new StructuredSelection((Object)dataPkg);
        viewer.setSelection((ISelection)dataPkgselection);
        IStatusLineManager projectExplorerStatusLineManager = viewer.getCommonNavigator().getViewSite().getActionBars().getStatusLineManager();
        String statusLineMsg = this.getStatusLineMessage(projectExplorerStatusLineManager);
        StatusLineTestCase.assertTrue((String)"The displayed message in status bar should be StatusLine::StatusLine::System Analysis::Data", (boolean)statusLineMsg.equals("StatusLine::StatusLine::System Analysis::Data"));
        DRepresentationDescriptor sdfb = null;
        Session session = this.getSession(this.projectTestName);
        for (DView entry : session.getOwnedViews()) {
            if (!entry.getViewpoint().getName().equals("System Analysis") || entry.getOwnedRepresentationDescriptors().size() <= 0) continue;
            sdfb = (DRepresentationDescriptor)entry.getOwnedRepresentationDescriptors().get(0);
        }
        DialectManager.INSTANCE.getAllRepresentations(session);
        StructuredSelection sdfbSelection = new StructuredSelection(sdfb);
        viewer.setSelection((ISelection)sdfbSelection);
        statusLineMsg = this.getStatusLineMessage(projectExplorerStatusLineManager);
        StatusLineTestCase.assertTrue((String)"The displayed message in status bar should be StatusLine::StatusLine::System Analysis::System Functions::Root System Function::[SDFB] Root System Function (Synchronized)", (boolean)statusLineMsg.equals("StatusLine::StatusLine::System Analysis::System Functions::Root System Function::[SDFB] Root System Function (Synchronized)"));
        viewer.setSelection(null);
    }
}

