/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.style.FlatContainerStyleDescription;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.UserFixedColor;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.test.diagram.common.ju.context.PABDiagram;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class PABStyleChecksDiagramElements
extends BasicTestCase {
    private static final String PROJECT_NAME = "component-breakdown";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(PROJECT_NAME);
    }

    public void test() throws Exception {
        Session session = this.getSession(PROJECT_NAME);
        PABStyleChecksDiagramElements.assertNotNull((Object)session);
        String systemId = "d09017b2-062e-4726-91e9-faeab75b6a56";
        SessionContext context = new SessionContext(session);
        PABDiagram diagram = PABDiagram.createDiagram((SessionContext)context, (String)systemId);
        String comp1_id = diagram.createNodeComponent("node_c1", diagram.getDiagramId());
        String comp2_id = diagram.createNodeComponent("node_c2", comp1_id);
        String comp3_id = diagram.createDeployedBehaviorComponent("depl_behavior_c3", comp1_id);
        String comp4_id = diagram.createDeployedBehaviorComponent("depl_behavior_c4", comp1_id);
        String comp5_id = diagram.createBehaviorComponent("behavior_c5", comp3_id);
        String comp6_id = diagram.createBehaviorComponent("behavior_c6", comp3_id);
        String actor1_id = diagram.createActor("actor1", comp1_id);
        String actor2_id = diagram.createBehaviorComponent("actor2", comp3_id);
        String actor3_id = diagram.createDeployedBehaviorComponent("actor3", comp1_id);
        String actor4_id = diagram.createDeployedBehaviorComponent("actor4", comp1_id);
        Part component1 = (Part)context.getSemanticElement(comp1_id);
        Part component2 = (Part)context.getSemanticElement(comp2_id);
        Part component3 = (Part)context.getSemanticElement(comp3_id);
        Part component4 = (Part)context.getSemanticElement(comp4_id);
        Part component5 = (Part)context.getSemanticElement(comp5_id);
        Part component6 = (Part)context.getSemanticElement(comp6_id);
        Part actor1 = (Part)context.getSemanticElement(actor1_id);
        Part actor2 = (Part)context.getSemanticElement(actor2_id);
        Part actor3 = (Part)context.getSemanticElement(actor3_id);
        Part actor4 = (Part)context.getSemanticElement(actor4_id);
        this.checksOnComponent(component1, false, false, PhysicalComponentNature.NODE);
        this.checksOnComponent(component2, false, false, PhysicalComponentNature.NODE);
        this.checksOnComponent(component3, false, false, PhysicalComponentNature.BEHAVIOR);
        this.checksOnComponent(component4, false, false, PhysicalComponentNature.BEHAVIOR);
        this.checksOnComponent(component5, false, false, PhysicalComponentNature.BEHAVIOR);
        this.checksOnComponent(actor1, true, false, PhysicalComponentNature.NODE);
        this.checksOnComponent(actor2, false, false, PhysicalComponentNature.BEHAVIOR);
        this.checksOnComponent(actor3, false, false, PhysicalComponentNature.BEHAVIOR);
        this.checksOnComponent(actor4, false, false, PhysicalComponentNature.BEHAVIOR);
        this.setFlagsOnComponent(context, component2, false, false, PhysicalComponentNature.UNSET);
        this.setFlagsOnComponent(context, component4, false, false, PhysicalComponentNature.NODE);
        this.setFlagsOnComponent(context, component6, false, false, PhysicalComponentNature.NODE);
        this.setFlagsOnComponent(context, actor2, true, false, PhysicalComponentNature.NODE);
        this.setFlagsOnComponent(context, actor3, true, false, PhysicalComponentNature.NODE);
        this.checksStyleOnComponent(diagram, component1, false);
        this.checksStyleOnComponent(diagram, component2, false);
        this.checksStyleOnComponent(diagram, component3, true);
        this.checksStyleOnComponent(diagram, component4, true);
        this.checksStyleOnComponent(diagram, component5, false);
        this.checksStyleOnComponent(diagram, component6, false);
        this.checksStyleOnComponent(diagram, actor1, false);
        this.checksStyleOnComponent(diagram, actor2, false);
        this.checksStyleOnComponent(diagram, actor3, true);
        this.checksStyleOnComponent(diagram, actor4, true);
    }

    protected void setFlagsOnComponent(SessionContext context, Part part, final boolean isActor, final boolean isHuman, final PhysicalComponentNature nature) {
        final PhysicalComponent component = (PhysicalComponent)part.getAbstractType();
        TestHelper.getExecutionManager((Session)context.getSession()).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                component.setHuman(isHuman);
                component.setActor(isActor);
                component.setNature(nature);
            }
        });
    }

    protected void checksOnComponent(Part part, boolean isActor, boolean isHuman, PhysicalComponentNature nature) {
        PhysicalComponent component = (PhysicalComponent)part.getAbstractType();
        PABStyleChecksDiagramElements.assertTrue((String)("Component " + component.getName() + " isActor should be " + isActor), (component.isActor() == isActor ? 1 : 0) != 0);
        PABStyleChecksDiagramElements.assertTrue((String)("Component " + component.getName() + " isHuman should be " + isActor), (component.isHuman() == isHuman ? 1 : 0) != 0);
        PABStyleChecksDiagramElements.assertTrue((String)("Component " + component.getName() + " nature should be " + nature), (component.getNature() == nature ? 1 : 0) != 0);
    }

    protected void checksStyleOnComponent(PABDiagram diagram, Part part, boolean isRounded) {
        PhysicalComponent component = (PhysicalComponent)part.getAbstractType();
        DDiagramElement element = diagram.getView((EObject)part);
        Style style = element.getStyle();
        FlatContainerStyleDescription desc = (FlatContainerStyleDescription)style.getDescription();
        PABStyleChecksDiagramElements.assertTrue((desc.isRoundedCorner() == isRounded ? 1 : 0) != 0);
        UserFixedColor color = (UserFixedColor)desc.getBackgroundColor();
        String colorStr = color.getName();
        if (component.isActor()) {
            PABStyleChecksDiagramElements.assertTrue((boolean)colorStr.equals("_CAP_Actor_Blue_min"));
        } else if (component.getNature() == PhysicalComponentNature.NODE) {
            PABStyleChecksDiagramElements.assertTrue((boolean)colorStr.equals("_CAP_Node_Yellow_min"));
        } else if (component.getNature() == PhysicalComponentNature.BEHAVIOR) {
            PABStyleChecksDiagramElements.assertTrue((boolean)colorStr.equals("_CAP_Component_Blue_min"));
        } else if (component.getNature() == PhysicalComponentNature.UNSET) {
            PABStyleChecksDiagramElements.assertTrue((boolean)colorStr.equals("_CAP_Unset_Gray_min"));
        }
    }
}

