/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.junit.Assert;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.diagram.helpers.DAnnotationHelper;
import org.polarsys.capella.core.diagram.helpers.RepresentationAnnotationHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.test.diagram.common.ju.headless.selector.HeadlessCapellaAnalysisSelector;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class CloneDiagramTestCase
extends BasicTestCase {
    private String diagramName = "[CDB] Play Video Movie - Physical";
    private String projectName = "TestCloneDiagram";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Session session = this.getSession(this.projectName);
        HeadlessCapellaAnalysisSelector.INSTANCE.setSelectedURI(session, TestHelper.getAirdResource((Session)session).getURI());
    }

    public void test() throws Exception {
        Session session = this.getSession(this.projectName);
        CloneDiagramTestCase.assertNotNull((Object)session);
        final DRepresentation originalRepresentation = DiagramHelper.getDRepresentation((Session)session, (String)this.diagramName);
        final DRepresentationDescriptor originalDescriptor = RepresentationHelper.getRepresentationDescriptor((Session)session, (DRepresentation)originalRepresentation);
        final int sizeBforeCopy = originalDescriptor.getEAnnotations().size();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)originalDescriptor);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                DRepresentationDescriptor clonedDescriptor = GuiActions.CloneDiagram((DRepresentationDescriptor)originalDescriptor);
                Assert.assertNotEquals((Object)originalDescriptor.getName(), (Object)clonedDescriptor.getName());
                CloneDiagramTestCase.assertEquals((String)originalRepresentation.getDocumentation(), (String)clonedDescriptor.getDocumentation());
                int sizeAfterCopy = clonedDescriptor.getEAnnotations().size();
                CloneDiagramTestCase.assertEquals((int)sizeBforeCopy, (int)sizeAfterCopy);
                DAnnotation originalAnnotation = DAnnotationHelper.getAnnotation((String)"https://www.polarsys.org/capella/dannotation/package", (DModelElement)originalDescriptor, (boolean)false);
                DAnnotation clonedAnnotation = DAnnotationHelper.getAnnotation((String)"https://www.polarsys.org/capella/dannotation/package", (DModelElement)clonedDescriptor, (boolean)false);
                CloneDiagramTestCase.assertNotNull((Object)clonedAnnotation);
                String originalPkg = (String)originalAnnotation.getDetails().get((Object)"name");
                String clonedPkg = (String)clonedAnnotation.getDetails().get((Object)"name");
                CloneDiagramTestCase.assertEquals((String)originalPkg, (String)clonedPkg);
                List originalContextualElements = ContextualDiagramHelper.getService().getContextualElements(originalDescriptor);
                List contextualElements = ContextualDiagramHelper.getService().getContextualElements(clonedDescriptor);
                Assert.assertArrayEquals((Object[])originalContextualElements.toArray(), (Object[])contextualElements.toArray());
                CloneDiagramTestCase.assertEquals((boolean)RepresentationAnnotationHelper.isVisibleInDoc((DRepresentationDescriptor)originalDescriptor), (boolean)RepresentationAnnotationHelper.isVisibleInDoc((DRepresentationDescriptor)clonedDescriptor));
                CloneDiagramTestCase.assertEquals((boolean)RepresentationAnnotationHelper.isVisibleInLM((DRepresentationDescriptor)originalDescriptor), (boolean)RepresentationAnnotationHelper.isVisibleInLM((DRepresentationDescriptor)clonedDescriptor));
                CloneDiagramTestCase.assertEquals((String)RepresentationAnnotationHelper.getStatusReview((DRepresentationDescriptor)originalDescriptor), (String)RepresentationAnnotationHelper.getStatusReview((DRepresentationDescriptor)clonedDescriptor));
                CloneDiagramTestCase.assertEquals((Object)RepresentationAnnotationHelper.getProgressStatus((DRepresentationDescriptor)originalDescriptor), (Object)RepresentationAnnotationHelper.getProgressStatus((DRepresentationDescriptor)clonedDescriptor));
            }
        });
    }
}

