/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ODesignHelper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.SiriusElementHelper;
import org.polarsys.capella.test.diagram.misc.ju.Messages;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.SessionHelper;

public class CheckDiagramDirtyStateOnOpeningTestCase
extends BasicTestCase {
    private static final String projectTestName = "EOLE_AF_UC";
    public static final String[] unsupportedDiagrams = new String[]{"Capella Architecture"};

    public List<String> getRequiredTestModels() {
        return Arrays.asList(projectTestName);
    }

    public void test() {
        Session session = this.getSession(projectTestName);
        Assert.assertNotNull((Object)session);
        ResourceSet resourceSet = TransactionHelper.getEditingDomain((Session)session).getResourceSet();
        List odesigns = ODesignHelper.getAvailableODesignFile((ResourceSet)resourceSet);
        List ddescs = ODesignHelper.getAllDiagramDescription((List)odesigns);
        for (DiagramDescription current : ddescs) {
            if (!this.isDiagramSupported(current.getName()) || current.getName().equals("AD diagram")) continue;
            this.checkDiagram(session, current.getName(), false);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        DiagramHelper.setPreferenceAutoRefresh((boolean)true);
        DiagramHelper.setPrefereneRefreshOnOpening((boolean)true);
    }

    protected boolean isDiagramSupported(String id) {
        boolean result = true;
        String[] stringArray = unsupportedDiagrams;
        int n = unsupportedDiagrams.length;
        int n2 = 0;
        while (n2 < n) {
            String unsupportedDiagram = stringArray[n2];
            if (id.equals(unsupportedDiagram)) {
                result = false;
                break;
            }
            ++n2;
        }
        return result;
    }

    public void checkDiagram(Session session, String diagramType, boolean mustBeRefreshed) {
        DRepresentation dRepresentation = this.getDiagramToOpen(session, diagramType);
        Assert.assertNotNull((String)NLS.bind((String)Messages.nullDiagram, (Object)this.getName()), (Object)dRepresentation);
        DiagramHelper.opendiagramEditor((Session)session, (DRepresentation)dRepresentation);
        if (mustBeRefreshed || dRepresentation.getOwnedRepresentationElements().isEmpty()) {
            boolean ret = DiagramHelper.refreshDiagram((DDiagram)((DDiagram)dRepresentation));
            Assert.assertTrue((String)NLS.bind((String)Messages.failToRefreshDiagram, (Object[])new Object[]{this.getName(), EObjectExt.getText((EObject)dRepresentation)}), (boolean)ret);
        }
        Assert.assertTrue((String)NLS.bind((String)Messages.sessionDirtyAfterDiagramOpening, (Object)diagramType), (boolean)SessionStatus.SYNC.equals((Object)session.getStatus()));
        SessionHelper.saveSession((Session)this.getSession(projectTestName));
    }

    protected DRepresentation getDiagramToOpen(Session session, String diagramType) {
        Collection allDSemanticDiagrams = SiriusElementHelper.getAllDSemanticDiagrams((Session)session);
        for (DRepresentation current : allDSemanticDiagrams) {
            DDiagram d = (DDiagram)current;
            if (!d.getDescription().getName().equals(diagramType)) continue;
            return d;
        }
        Assert.fail((String)("No diagram found in model with type " + diagramType));
        return null;
    }
}

