/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.CategoryWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.ui.semantic.browser.sirius.view.SiriusSemanticBrowserView;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public abstract class AbstractOrderInSemanticBrowserTest
extends BasicTestCase {
    protected String projectTestName = "SBOrdering";
    protected SiriusSemanticBrowserView semanticBrowserViewer;
    protected IScope scope;

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectTestName);
    }

    protected abstract String getScopeElement();

    protected void setUp() throws Exception {
        super.setUp();
        CapellaModel model = this.getTestModel(this.projectTestName);
        this.scope = new ScopeModelWrapper((IModel)model);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
        this.semanticBrowserViewer = this.getSemanticBrowserViewer();
        this.semanticBrowserViewer.activateListeningToPageSelectionEvents();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this.semanticBrowserViewer);
        EObject scenario = IdManager.getInstance().getEObject(this.getScopeElement(), this.scope);
        this.semanticBrowserViewer.saveInput((Object)scenario, null);
    }

    protected void tearDown() throws Exception {
        this.semanticBrowserViewer.activateListeningToPageSelectionEvents();
        super.tearDown();
    }

    protected SiriusSemanticBrowserView getSemanticBrowserViewer() {
        final SiriusSemanticBrowserView[] viewer = new SiriusSemanticBrowserView[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                viewer[0] = (SiriusSemanticBrowserView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
            }
        });
        return viewer[0];
    }

    protected void checkCategoryContentOrder(IScope scope, TreeItem categoryItem, String categoryName, String ... expectedObject) {
        AbstractOrderInSemanticBrowserTest.assertTrue((boolean)(categoryItem.getData() instanceof CategoryWrapper));
        AbstractOrderInSemanticBrowserTest.assertTrue((boolean)((CategoryWrapper)categoryItem.getData()).getElement().getName().equals(categoryName));
        TreeItem[] eObjectItems = categoryItem.getItems();
        int i = 0;
        while (i < eObjectItems.length) {
            EObject message = IdManager.getInstance().getEObject(expectedObject[i], scope);
            EObjectWrapper wrappedMessage = new EObjectWrapper(message);
            AbstractOrderInSemanticBrowserTest.assertEquals((Object)wrappedMessage, (Object)eObjectItems[i].getData());
            ++i;
        }
    }
}

