/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.workspace;

import org.eclipse.buildship.ui.workspace.GradleClasspathContainerRefresher;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;

public final class RefreshProjectCommandExecutionListener
implements IExecutionListener {
    private ExecutionEvent event;

    public void preExecute(String commandId, ExecutionEvent event) {
        this.event = event;
    }

    public void postExecuteSuccess(String commandId, Object returnValue) {
        if (this.isFileRefreshCommand(commandId) && this.isGradleNatureContextEnabled()) {
            this.refreshGradleProject(this.event);
        }
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
        if (this.isFileRefreshCommand(commandId) && this.isGradleNatureContextEnabled()) {
            this.refreshGradleProject(this.event);
        }
    }

    public void notHandled(String commandId, NotHandledException exception) {
    }

    private boolean isFileRefreshCommand(String commandId) {
        return commandId.equals("org.eclipse.ui.file.refresh");
    }

    private boolean isGradleNatureContextEnabled() {
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        return contextService.getActiveContextIds().contains("org.eclipse.buildship.ui.contexts.gradlenature");
    }

    private void refreshGradleProject(ExecutionEvent event) {
        GradleClasspathContainerRefresher.execute(event);
    }
}

