/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.EncryptionEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.EncryptionUtil;

public class EncryptionRecord
extends SimpleRecord {
    protected DesignElement element = null;
    protected ElementPropertyDefn prop = null;
    protected String newEncryption = null;
    protected String oldEncryption = null;
    protected Object oldLocalValue = null;
    protected Object oldValue = null;

    public EncryptionRecord(Module module, DesignElement obj, ElementPropertyDefn propDefn, String encryption) {
        this.element = obj;
        this.prop = propDefn;
        this.newEncryption = encryption;
        this.oldEncryption = this.element.getLocalEncryptionID(propDefn);
        this.oldValue = this.element.getProperty(module, this.prop);
        this.oldLocalValue = this.element.getLocalProperty(module, this.prop);
        this.label = CommandLabelFactory.getCommandLabel("Message.ChangePropertyEncryption", new String[]{propDefn.getDisplayName()});
    }

    @Override
    protected void perform(boolean undo) {
        String encryptionID;
        String string = encryptionID = undo ? this.oldEncryption : this.newEncryption;
        if (this.oldValue == null) {
            this.element.setEncryptionHelper(this.prop, encryptionID);
        } else if (this.oldLocalValue != null) {
            if (encryptionID == null) {
                encryptionID = this.element.getEncryptionID(this.prop);
            }
            Object newValue = EncryptionUtil.encrypt(this.prop, encryptionID, this.oldLocalValue);
            this.element.setProperty(this.prop, newValue);
            this.element.setEncryptionHelper(this.prop, encryptionID);
        } else {
            if (!undo && encryptionID == null) {
                encryptionID = this.element.getEncryptionID(this.prop);
            }
            Object newValue = undo ? null : EncryptionUtil.encrypt(this.prop, encryptionID, this.oldValue);
            this.element.setProperty(this.prop, newValue);
            this.element.setEncryptionHelper(this.prop, encryptionID);
        }
    }

    @Override
    public DesignElement getTarget() {
        return this.element;
    }

    @Override
    public NotificationEvent getEvent() {
        return new EncryptionEvent(this.element, this.prop, this.oldEncryption, this.newEncryption);
    }
}

