/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.series;

import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.component.Dial;
import org.eclipse.birt.chart.model.component.DialRegion;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.DialRegionImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartNumberEditor;
import org.eclipse.birt.chart.ui.swt.AbstractChartTextEditor;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextNumberEditorAssistField;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;

public class SeriesRegionSheet
extends AbstractPopupSheet
implements SelectionListener,
ModifyListener,
Listener {
    private transient Composite cmpContent;
    private transient Composite cmpList = null;
    private transient Button btnAddRange = null;
    private transient Button btnRemove = null;
    private transient List lstMarkers = null;
    private transient Group grpGeneral = null;
    private transient Composite cmpRange = null;
    private transient Group grpMarkerRange = null;
    private transient Label lblStartValue = null;
    private transient AbstractChartTextEditor txtStartValue = null;
    private transient Label lblEndValue = null;
    private transient AbstractChartTextEditor txtEndValue = null;
    private transient Label lblInnerRadius = null;
    private transient AbstractChartNumberEditor txtInnerRadius = null;
    private transient Label lblOuterRadius = null;
    private transient AbstractChartNumberEditor txtOuterRadius = null;
    private transient Label lblRangeFill = null;
    private transient FillChooserComposite fccRange = null;
    private transient LineAttributesComposite liacMarkerRange = null;
    private transient int iRangeCount = 0;
    private transient SeriesDefinition seriesDefn;
    private Series series;
    private Series defSeries = null;

    @Deprecated
    public SeriesRegionSheet(String title, ChartWizardContext context, SeriesDefinition seriesDefn) {
        super(title, context, false);
        this.seriesDefn = seriesDefn;
    }

    public SeriesRegionSheet(String title, ChartWizardContext context, Series series) {
        super(title, context, false);
        this.series = series;
        this.defSeries = ChartDefaultValueUtil.getDefaultSeries((Series)series);
    }

    @Override
    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.MeterChartRegions_ID");
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)glContent);
        GridLayout glList = new GridLayout();
        glList.numColumns = 3;
        glList.horizontalSpacing = 5;
        glList.verticalSpacing = 5;
        glList.marginHeight = 0;
        glList.marginWidth = 0;
        this.cmpList = new Composite(this.cmpContent, 0);
        GridData gdCMPList = new GridData(1808);
        gdCMPList.horizontalSpan = 2;
        this.cmpList.setLayoutData((Object)gdCMPList);
        this.cmpList.setLayout((Layout)glList);
        GridLayout glButtons = new GridLayout();
        glButtons.numColumns = 3;
        glButtons.horizontalSpacing = 5;
        glButtons.verticalSpacing = 5;
        glButtons.marginHeight = 5;
        glButtons.marginWidth = 0;
        Composite cmpButtons = new Composite(this.cmpList, 0);
        GridData gdCMPButtons = new GridData(768);
        gdCMPButtons.horizontalSpan = 3;
        cmpButtons.setLayoutData((Object)gdCMPButtons);
        cmpButtons.setLayout((Layout)glButtons);
        this.btnAddRange = new Button(cmpButtons, 8);
        GridData gdBTNAddRange = new GridData(768);
        this.btnAddRange.setLayoutData((Object)gdBTNAddRange);
        this.btnAddRange.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.AddRegion"));
        this.btnAddRange.addSelectionListener((SelectionListener)this);
        this.btnRemove = new Button(cmpButtons, 8);
        GridData gdBTNRemove = new GridData(768);
        this.btnRemove.setLayoutData((Object)gdBTNRemove);
        this.btnRemove.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.RemoveEntry"));
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.lstMarkers = new List(this.cmpList, 2564);
        GridData gdLSTMarkers = new GridData(768);
        gdLSTMarkers.horizontalSpan = 3;
        gdLSTMarkers.heightHint = 100;
        this.lstMarkers.setLayoutData((Object)gdLSTMarkers);
        this.lstMarkers.addSelectionListener((SelectionListener)this);
        this.grpGeneral = new Group(this.cmpContent, 0);
        GridData gdCMPGeneral = new GridData(770);
        gdCMPGeneral.widthHint = 200;
        this.grpGeneral.setLayoutData((Object)gdCMPGeneral);
        this.grpGeneral.setLayout((Layout)new GridLayout());
        this.grpGeneral.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.DialProperties"));
        GridLayout glMarkerRange = new GridLayout();
        glMarkerRange.numColumns = 3;
        glMarkerRange.horizontalSpacing = 5;
        glMarkerRange.verticalSpacing = 5;
        glMarkerRange.marginHeight = 7;
        glMarkerRange.marginWidth = 7;
        this.cmpRange = new Composite((Composite)this.grpGeneral, 0);
        GridData gdGRPRange = new GridData(768);
        this.cmpRange.setLayoutData((Object)gdGRPRange);
        this.cmpRange.setLayout((Layout)glMarkerRange);
        GridLayout glRangeValue = new GridLayout();
        glRangeValue.numColumns = 3;
        glRangeValue.horizontalSpacing = 2;
        glRangeValue.verticalSpacing = 5;
        glRangeValue.marginHeight = 0;
        glRangeValue.marginWidth = 0;
        Composite cmpRangeValue = new Composite(this.cmpRange, 0);
        GridData gdCMPRangeValue = new GridData(768);
        gdCMPRangeValue.horizontalSpan = 3;
        cmpRangeValue.setLayoutData((Object)gdCMPRangeValue);
        cmpRangeValue.setLayout((Layout)glRangeValue);
        this.lblStartValue = new Label(cmpRangeValue, 0);
        GridData gdLBLStartValue = new GridData();
        gdLBLStartValue.horizontalIndent = 5;
        this.lblStartValue.setLayoutData((Object)gdLBLStartValue);
        this.lblStartValue.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.StartValue"));
        this.txtStartValue = this.getContext().getUIFactory().createChartTextEditor(cmpRangeValue, 2052, null, "startValue");
        new TextNumberEditorAssistField(this.txtStartValue.getTextControl(), null);
        GridData gdTXTStartValue = new GridData(768);
        gdTXTStartValue.horizontalSpan = 2;
        this.txtStartValue.setLayoutData((Object)gdTXTStartValue);
        this.txtStartValue.addListener((Listener)this);
        this.lblEndValue = new Label(cmpRangeValue, 0);
        GridData gdLBLEndValue = new GridData();
        gdLBLEndValue.horizontalIndent = 5;
        this.lblEndValue.setLayoutData((Object)gdLBLEndValue);
        this.lblEndValue.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.EndValue"));
        this.txtEndValue = this.getContext().getUIFactory().createChartTextEditor(cmpRangeValue, 2052, null, "endValue");
        new TextNumberEditorAssistField(this.txtEndValue.getTextControl(), null);
        GridData gdTXTEndValue = new GridData(768);
        gdTXTEndValue.horizontalSpan = 2;
        this.txtEndValue.setLayoutData((Object)gdTXTEndValue);
        this.txtEndValue.addListener((Listener)this);
        if (this.supportRadius()) {
            this.lblInnerRadius = new Label(cmpRangeValue, 0);
            GridData gdLBLInnerRadius = new GridData();
            gdLBLInnerRadius.horizontalIndent = 5;
            this.lblInnerRadius.setLayoutData((Object)gdLBLInnerRadius);
            this.lblInnerRadius.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.InnerRadius"));
            this.txtInnerRadius = this.getContext().getUIFactory().createChartNumberEditor(cmpRangeValue, 2052, null, null, "innerRadius");
            new TextNumberEditorAssistField(this.txtInnerRadius.getTextControl(), null);
            GridData gdTXTInnerRadius = new GridData(768);
            gdTXTInnerRadius.horizontalSpan = 2;
            this.txtInnerRadius.setLayoutData((Object)gdTXTInnerRadius);
            this.txtInnerRadius.addModifyListener((ModifyListener)this);
            this.lblOuterRadius = new Label(cmpRangeValue, 0);
            GridData gdLBLOuterRadius = new GridData();
            gdLBLOuterRadius.horizontalIndent = 5;
            this.lblOuterRadius.setLayoutData((Object)gdLBLOuterRadius);
            this.lblOuterRadius.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.OuterRadius"));
            this.txtOuterRadius = this.getContext().getUIFactory().createChartNumberEditor(cmpRangeValue, 2052, null, null, "outerRadius");
            new TextNumberEditorAssistField(this.txtOuterRadius.getTextControl(), null);
            GridData gdTXTOuterRadius = new GridData(768);
            gdTXTOuterRadius.horizontalSpan = 2;
            this.txtOuterRadius.setLayoutData((Object)gdTXTOuterRadius);
            this.txtOuterRadius.addModifyListener((ModifyListener)this);
        }
        this.lblRangeFill = new Label(this.cmpRange, 0);
        GridData gdLBLRangeFill = new GridData();
        gdLBLRangeFill.horizontalIndent = 5;
        this.lblRangeFill.setLayoutData((Object)gdLBLRangeFill);
        this.lblRangeFill.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.Fill"));
        int fillStyles = 25;
        fillStyles |= this.getContext().getUIFactory().supportAutoUI() ? 4 : fillStyles;
        fillStyles = this.supportPatternAndImageFill() ? (fillStyles |= 2) : (fillStyles |= 0x80);
        this.fccRange = new FillChooserComposite(this.cmpRange, 0, fillStyles, this.getContext(), null);
        GridData gdFCCRange = new GridData(768);
        gdFCCRange.horizontalSpan = 2;
        this.fccRange.setLayoutData(gdFCCRange);
        this.fccRange.addListener(this);
        if (this.supportRangeOutline()) {
            this.grpMarkerRange = new Group(this.cmpRange, 0);
            GridData gdGRPMarkerRange = new GridData(768);
            gdGRPMarkerRange.horizontalSpan = 3;
            this.grpMarkerRange.setLayoutData((Object)gdGRPMarkerRange);
            this.grpMarkerRange.setLayout((Layout)new FillLayout());
            this.grpMarkerRange.setText(Messages.getString("BaseAxisMarkerAttributeSheetImpl.Lbl.RangeOutline"));
            int lineStyles = 15;
            this.liacMarkerRange = new LineAttributesComposite((Composite)this.grpMarkerRange, 0, lineStyles |= this.getContext().getUIFactory().supportAutoUI() ? 16 : lineStyles, this.getContext(), null, ((DialRegion)((DialSeries)this.defSeries).getDial().getDialRegions().get(0)).getOutline());
            this.liacMarkerRange.addListener(this);
        }
        this.populateLists();
        this.refreshButtons();
        return this.cmpContent;
    }

    protected boolean supportPatternAndImageFill() {
        return true;
    }

    protected boolean supportRangeOutline() {
        return true;
    }

    protected boolean supportRadius() {
        return true;
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fccRange)) {
            ((DialRegion)this.getDialForProcessing().getDialRegions().get(this.getMarkerIndex())).setFill((Fill)event.data);
        } else if (event.widget.equals(this.txtStartValue)) {
            if (!"Reset".equals(event.data)) {
                int iMarkerIndex = this.getMarkerIndex();
                ((DialRegion)this.getDialForProcessing().getDialRegions().get(iMarkerIndex)).setStartValue(this.getTypedDataElement(this.txtStartValue.getText()));
            }
        } else if (event.widget.equals(this.txtEndValue)) {
            if (!"Reset".equals(event.data)) {
                int iMarkerIndex = this.getMarkerIndex();
                ((DialRegion)this.getDialForProcessing().getDialRegions().get(iMarkerIndex)).setEndValue(this.getTypedDataElement(this.txtEndValue.getText()));
            }
        } else if (event.widget.equals((Object)this.liacMarkerRange)) {
            boolean isUnset;
            boolean bl = isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
            if (event.type == 1) {
                ChartElementUtil.setEObjectAttribute((EObject)((DialRegion)this.getDialForProcessing().getDialRegions().get(this.getMarkerIndex())).getOutline(), (String)"style", (Object)event.data, (boolean)isUnset);
            } else if (event.type == 2) {
                ChartElementUtil.setEObjectAttribute((EObject)((DialRegion)this.getDialForProcessing().getDialRegions().get(this.getMarkerIndex())).getOutline(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
            } else if (event.type == 3) {
                ((DialRegion)this.getDialForProcessing().getDialRegions().get(this.getMarkerIndex())).getOutline().setColor((ColorDefinition)event.data);
            } else {
                ChartElementUtil.setEObjectAttribute((EObject)((DialRegion)this.getDialForProcessing().getDialRegions().get(this.getMarkerIndex())).getOutline(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        int markerIndex = this.getMarkerIndex();
        if (markerIndex >= 0) {
            if (e.widget.equals(this.txtInnerRadius)) {
                if (!"Reset".equals(e.data)) {
                    if (this.txtInnerRadius.isSetValue()) {
                        ((DialRegion)this.getDialForProcessing().getDialRegions().get(this.getMarkerIndex())).setInnerRadius(this.txtInnerRadius.getValue());
                    } else {
                        ((DialRegion)this.getDialForProcessing().getDialRegions().get(this.getMarkerIndex())).unsetInnerRadius();
                    }
                }
            } else if (e.widget.equals(this.txtOuterRadius) && !"Reset".equals(e.data)) {
                if (this.txtOuterRadius.isSetValue()) {
                    ((DialRegion)this.getDialForProcessing().getDialRegions().get(this.getMarkerIndex())).setOuterRadius(this.txtOuterRadius.getValue());
                } else {
                    ((DialRegion)this.getDialForProcessing().getDialRegions().get(this.getMarkerIndex())).unsetOuterRadius();
                }
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnAddRange)) {
            DialRegion range = null;
            range = this.getContext().getUIFactory().supportAutoUI() ? DialRegionImpl.createDefault() : DialRegionImpl.create();
            range.setStartValue(this.getTypedDataElement(null));
            range.setEndValue(this.getTypedDataElement(null));
            this.getDialForProcessing().getDialRegions().add((Object)range);
            range.eAdapters().addAll((Collection)this.getDialForProcessing().eAdapters());
            ++this.iRangeCount;
            this.buildList();
            this.lstMarkers.select(this.lstMarkers.getItemCount() - 1);
            this.updateUIForSelection();
            if (this.lstMarkers.getItemCount() == 1) {
                this.setState(true);
            }
            this.refreshButtons();
        } else if (e.getSource().equals(this.btnRemove)) {
            if (this.lstMarkers.getSelection().length == 0) {
                return;
            }
            int iMarkerIndex = this.getMarkerIndex();
            this.getDialForProcessing().getDialRegions().remove(iMarkerIndex);
            --this.iRangeCount;
            this.buildList();
            if (this.lstMarkers.getItemCount() > 0) {
                this.lstMarkers.select(0);
                this.updateUIForSelection();
            } else {
                this.resetUI();
                this.setState(false);
            }
            this.refreshButtons();
        } else if (e.getSource().equals(this.lstMarkers)) {
            this.updateUIForSelection();
            this.refreshButtons();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private Dial getDialForProcessing() {
        if (this.series != null) {
            return ((DialSeries)this.series).getDial();
        }
        return ((DialSeries)this.seriesDefn.getDesignTimeSeries()).getDial();
    }

    private String getValueAsString(DataElement de) {
        if (de != null) {
            return ChartUIUtil.getDefaultNumberFormatInstance().format(((NumberDataElement)de).getValue());
        }
        return "";
    }

    private int getMarkerIndex() {
        int iSelectionIndex = this.lstMarkers.getSelectionIndex();
        return iSelectionIndex;
    }

    private void buildList() {
        this.lstMarkers.removeAll();
        this.iRangeCount = this.getDialForProcessing().getDialRegions().size();
        int iRanges = 0;
        while (iRanges < this.iRangeCount) {
            this.lstMarkers.add(String.valueOf(Messages.getString("SeriesRegionSheet.message.dialRegion")) + (iRanges + 1));
            ++iRanges;
        }
    }

    private void refreshButtons() {
        this.btnRemove.setEnabled(this.lstMarkers.getSelectionIndex() != -1);
    }

    private void updateUIForSelection() {
        this.grpGeneral.layout();
        int iRangeIndex = this.getMarkerIndex();
        DialRegion range = (DialRegion)this.getDialForProcessing().getDialRegions().get(iRangeIndex);
        this.txtStartValue.setEObjectParent((EObject)range);
        this.txtStartValue.setText(this.getValueAsString(range.getStartValue()));
        this.txtEndValue.setEObjectParent((EObject)range);
        this.txtEndValue.setText(this.getValueAsString(range.getEndValue()));
        if (this.supportRadius()) {
            this.txtInnerRadius.setEObjectParent((EObject)range);
            if (range.isSetInnerRadius()) {
                this.txtInnerRadius.setValue(range.getInnerRadius());
            } else {
                this.txtInnerRadius.unsetValue();
            }
            this.txtOuterRadius.setEObjectParent((EObject)range);
            if (range.isSetOuterRadius()) {
                this.txtOuterRadius.setValue(range.getOuterRadius());
            } else {
                this.txtOuterRadius.unsetValue();
            }
        }
        this.fccRange.setFill(range.getFill());
        if (this.supportRangeOutline()) {
            this.liacMarkerRange.setLineAttributes(range.getOutline());
        }
    }

    private void populateLists() {
        this.buildList();
        if (this.lstMarkers.getItemCount() > 0) {
            this.lstMarkers.select(0);
            this.updateUIForSelection();
        } else {
            this.setState(false);
        }
    }

    private void setState(boolean bState) {
        this.lblStartValue.setEnabled(bState);
        this.txtStartValue.setEnabled(bState);
        this.lblEndValue.setEnabled(bState);
        this.txtEndValue.setEnabled(bState);
        if (this.supportRadius()) {
            this.lblInnerRadius.setEnabled(bState);
            this.txtInnerRadius.setEnabled(bState);
            this.lblOuterRadius.setEnabled(bState);
            this.txtOuterRadius.setEnabled(bState);
        }
        if (this.supportRangeOutline()) {
            this.liacMarkerRange.setAttributesEnabled(bState);
            this.grpMarkerRange.setEnabled(bState);
        }
        this.lblRangeFill.setEnabled(bState);
        this.fccRange.setEnabled(bState);
        this.grpGeneral.setEnabled(bState);
    }

    private void resetUI() {
        this.txtStartValue.setText("");
        this.txtEndValue.setText("");
        if (this.supportRadius()) {
            this.txtInnerRadius.unsetValue();
            this.txtOuterRadius.unsetValue();
        }
        this.fccRange.setFill(null);
        if (this.supportRangeOutline()) {
            this.liacMarkerRange.setLineAttributes(null);
            this.liacMarkerRange.layout();
        }
    }

    private DataElement getTypedDataElement(String strDataElement) {
        if (strDataElement == null) {
            return null;
        }
        if (strDataElement.trim().length() == 0) {
            return NumberDataElementImpl.create((double)0.0);
        }
        NumberFormat nf = ChartUIUtil.getDefaultNumberFormatInstance();
        try {
            Number numberElement = nf.parse(strDataElement);
            return NumberDataElementImpl.create((double)numberElement.doubleValue());
        }
        catch (ParseException e1) {
            return NumberDataElementImpl.create((double)0.0);
        }
    }
}

