/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.profile.internal;

import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;

public class ProfileCategoryUtil {
    public static ICategory getCategory(String odaDataSourceId) {
        IConnectionProfileProvider profileProvider = ConnectionProfileManager.getInstance().getProvider(odaDataSourceId);
        return profileProvider != null ? profileProvider.getCategory() : null;
    }

    public static boolean isUnknownCategory(ICategory profileCategory) {
        String categoryId = profileCategory != null ? profileCategory.getId() : null;
        return ProfileCategoryUtil.isUnknownCategory(categoryId);
    }

    public static boolean isUnknownCategory(String categoryId) {
        return categoryId == null || categoryId.equals("org.eclipse.datatools.connectivity.category.unknown");
    }

    public static boolean hasODAParentCategory(ICategory profileCategory) {
        if (profileCategory == null || profileCategory.getParent() == null) {
            return false;
        }
        return profileCategory.getParent().getId().equalsIgnoreCase("org.eclipse.datatools.connectivity.oda.profileCategory");
    }
}

