/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.visualization.ui;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class VisualizationParameters {
    final Map<String, String> parameters;

    public VisualizationParameters() {
        this.parameters = new HashMap<String, String>();
    }

    public VisualizationParameters(String initString) {
        this.parameters = this.readFromString(initString);
    }

    public String get(String key) {
        return this.parameters.get(key);
    }

    public String getOrDefault(Object key, String defaultValue) {
        return this.parameters.getOrDefault(key, defaultValue);
    }

    public String put(String key, String value) {
        return this.parameters.put(key, value);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String toString() {
        return this.parameters.entrySet().stream().map(e -> String.valueOf(this.encode((String)e.getKey())) + ":" + this.encode((String)e.getValue())).collect(Collectors.joining(" # ", "{", "}"));
    }

    private Map<String, String> readFromString(String string) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (string != null && string.startsWith("{") && string.endsWith("}")) {
            String entries = string.substring(1, string.length() - 1);
            String[] stringArray = entries.split("#");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                String[] keyValue = entry.split(":");
                if (keyValue.length == 2) {
                    map.put(this.decode(keyValue[0].trim()), this.decode(keyValue[1].trim()));
                }
                ++n2;
            }
        }
        return map;
    }

    private String decode(String s) {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private String encode(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

