/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.editor.search.ModelSearchResult;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SearchResultTreeContentProvider
extends TreeNodeContentProvider {
    private final Object[] NO_OBJECTS = new Object[0];
    private final TreeNode[] NO_NODES = new TreeNode[0];
    private ModelSearchResult searchResult;
    private Object[] elements = this.NO_OBJECTS;
    private TreeNode[] types = this.NO_NODES;

    public void dispose() {
    }

    public void clear() {
        this.elements = this.NO_OBJECTS;
        this.types = this.NO_NODES;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clear();
        if (newInput instanceof ModelSearchResult) {
            this.searchResult = (ModelSearchResult)((Object)newInput);
            this.elements = this.searchResult.getElements();
            Arrays.parallelSort(this.elements, new ObjectComparator());
        } else {
            this.searchResult = null;
        }
    }

    public void addElements(Object[] newElements) {
        if (newElements.length == 0) {
            return;
        }
        this.elements = this.concatenate(this.elements, newElements);
        Arrays.parallelSort(this.elements, new ObjectComparator());
        this.types = this.NO_NODES;
    }

    private Object[] concatenate(Object[] a, Object[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = new Object[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != this.searchResult || this.elements.length == 0) {
            return this.NO_OBJECTS;
        }
        if (this.types.length == 0) {
            HashMap tmpMap = new HashMap();
            Object[] objectArray = this.elements;
            int n = this.elements.length;
            int n2 = 0;
            while (n2 < n) {
                List<TreeNode> tmpList;
                Object element = objectArray[n2];
                String className = element.getClass().getName();
                TreeNode node = new TreeNode(element);
                if (tmpMap.containsKey(className)) {
                    tmpList = (List)tmpMap.get(className);
                } else {
                    tmpList = new ArrayList();
                    tmpMap.put(className, tmpList);
                }
                tmpList.add(node);
                ++n2;
            }
            Object[] classNames = tmpMap.keySet().toArray(new String[0]);
            Arrays.sort(classNames);
            ArrayList<TreeNode> typeList = new ArrayList<TreeNode>();
            Object[] objectArray2 = classNames;
            int n3 = classNames.length;
            int n4 = 0;
            while (n4 < n3) {
                Object name = objectArray2[n4];
                List nodeList = (List)tmpMap.get(name);
                EClass eClass = ((EObject)((TreeNode)nodeList.get(0)).getValue()).eClass();
                TreeNode typeNode = new TreeNode((Object)eClass);
                typeNode.setChildren(nodeList.toArray(new TreeNode[nodeList.size()]));
                typeList.add(typeNode);
                ++n4;
            }
            this.types = typeList.toArray(new TreeNode[typeList.size()]);
        }
        return this.types;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] tmp = super.getChildren(parentElement);
        return tmp != null ? tmp : this.NO_OBJECTS;
    }

    private class ObjectComparator
    implements Comparator<Object> {
        private ObjectComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            INamed n1 = (INamed)o1;
            INamed n2 = (INamed)o2;
            if (n1.getName() != null && n2.getName() != null) {
                return n1.getName().compareTo(n2.getName());
            }
            return 0;
        }
    }
}

