/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.xpath.utils.BulkXpathOperation;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAttributeRefCacheBuilder
implements ICache {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAttributeRefCacheBuilder.class);
    Map<File, Map<String, Object>> map = new HashMap<File, Map<String, Object>>();

    @Override
    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    @Override
    public void clearCacheMap() {
        this.map.clear();
    }

    protected Map<String, Element> getAllElements_referred_by_URIFragments(File targetFile, Document rootDocument, String URIFRAGMENT_ELEMENT_REFS_ATTRIBUTES) {
        Map uriFragment2schedulerRefAttribsMap = (Map)this.getCacheMap().get(targetFile).get(URIFRAGMENT_ELEMENT_REFS_ATTRIBUTES);
        if (uriFragment2schedulerRefAttribsMap == null) {
            LOGGER.error("cache : \"{}\" not populated", (Object)URIFRAGMENT_ELEMENT_REFS_ATTRIBUTES);
            return new HashMap<String, Element>();
        }
        Set<String> uriFragments = uriFragment2schedulerRefAttribsMap.keySet();
        Map<String, Element> uriFragment2ElementsMap = this.getAllElements_referred_by_URIFragments(rootDocument, uriFragments);
        return uriFragment2ElementsMap;
    }

    protected Map<String, Element> getAllElements_referred_by_URIFragments(Document rootDocument, Set<String> uriFragments) {
        HashMap<String, Element> uriFragment2ElementsMap = new HashMap<String, Element>();
        HashMap<String, String> uriFragment2XpathStringMap = new HashMap<String, String>();
        Map<Object, Object> xpath2ElementsMap = new HashMap();
        for (String uriFragment : uriFragments) {
            uriFragment2XpathStringMap.put(uriFragment, this.getXpathString(uriFragment));
        }
        BulkXpathOperation bulkXpathOperation = new BulkXpathOperation();
        xpath2ElementsMap = bulkXpathOperation.invokeXpath(rootDocument, uriFragment2XpathStringMap.values());
        for (String uriFragment : uriFragments) {
            if (uriFragment2ElementsMap.containsKey(uriFragment)) continue;
            String xpath = (String)uriFragment2XpathStringMap.get(uriFragment);
            List list = (List)xpath2ElementsMap.get(xpath);
            if (!list.isEmpty()) {
                uriFragment2ElementsMap.put(uriFragment, (Element)list.get(0));
                continue;
            }
            LOGGER.error("No references can be found for : {} corresponding Xpath used is : {}", (Object)uriFragment, (Object)xpath);
        }
        return uriFragment2ElementsMap;
    }

    protected void addAttributeTo_Href_URIFragment_Attributes_Cache(File targetFile, File refFile, String uriFragment_with_fileInfo, String fileNameInfo, String localURIFragment, Attribute attribute, String HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES) {
        Map reffile2uriFragment2schedulerRefAttribsMap = (Map)this.getCacheMap().get(targetFile).get(HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES);
        HashMap table = (HashMap)reffile2uriFragment2schedulerRefAttribsMap.get(refFile);
        if (table == null) {
            table = new HashMap();
            reffile2uriFragment2schedulerRefAttribsMap.put(refFile, table);
        }
        HashMap<String, ArrayList<Attribute>> attributeMap = (HashMap<String, ArrayList<Attribute>>)table.get(uriFragment_with_fileInfo);
        ArrayList<Attribute> attributes = null;
        if (attributeMap == null) {
            attributeMap = new HashMap<String, ArrayList<Attribute>>();
            table.put(uriFragment_with_fileInfo, attributeMap);
        } else {
            attributes = (ArrayList<Attribute>)attributeMap.get(localURIFragment);
        }
        if (attributes == null) {
            attributes = new ArrayList<Attribute>();
            attributeMap.put(localURIFragment, attributes);
        }
        attributes.add(attribute);
    }

    protected String getXpathString_old(String uriFragment) {
        if ((uriFragment = uriFragment.replace("@", "")).contains(".")) {
            int lastIndexOf = uriFragment.lastIndexOf(46);
            String substring = uriFragment.substring(lastIndexOf + 1);
            try {
                int arrayIndex = Integer.parseInt(substring) + 1;
                uriFragment = String.valueOf(uriFragment.substring(0, lastIndexOf)) + "[" + arrayIndex + "]";
            }
            catch (Exception e) {
                LOGGER.error("Exception occured during conversion of URIFragment : {} to Xpath String", (Object)uriFragment, (Object)e);
                throw e;
            }
        }
        return uriFragment;
    }

    protected String getXpathString(String uriFragment) {
        if ((uriFragment = uriFragment.replace("@", "")).contains(".")) {
            char[] charArray = uriFragment.toCharArray();
            boolean isBuildingIndex = false;
            StringBuilder xpathBuffer = new StringBuilder();
            StringBuilder indexBuffer = new StringBuilder();
            int i = 0;
            while (i < charArray.length) {
                if (charArray[i] == '.') {
                    xpathBuffer.append("[");
                    isBuildingIndex = true;
                    indexBuffer = new StringBuilder();
                } else if (isBuildingIndex && charArray[i] == '/') {
                    this.addIndexToBuffer(xpathBuffer, indexBuffer);
                    indexBuffer = new StringBuilder();
                    xpathBuffer.append("]");
                    xpathBuffer.append("/");
                    isBuildingIndex = false;
                } else if (isBuildingIndex) {
                    indexBuffer.append(charArray[i]);
                } else {
                    xpathBuffer.append(charArray[i]);
                }
                ++i;
            }
            if (isBuildingIndex) {
                this.addIndexToBuffer(xpathBuffer, indexBuffer);
                xpathBuffer.append("]");
            }
            uriFragment = xpathBuffer.toString();
        }
        return uriFragment;
    }

    private void addIndexToBuffer(StringBuilder xpathBuffer, StringBuilder indexBuffer) {
        try {
            long parseLong = Long.parseLong(indexBuffer.toString());
            xpathBuffer.append(parseLong + 1L);
        }
        catch (Exception e) {
            xpathBuffer.append((CharSequence)indexBuffer);
        }
    }

    protected Map<String, List<Attribute>> getAllAttributes_containing_URIFragments(Document rootDocument, String xPath_for_attributes, Namespace ... nameSpaces) {
        List<Attribute> schedulerAttributes = HelperUtil.getXpathResult(rootDocument, xPath_for_attributes, Attribute.class, nameSpaces);
        HashMap<String, List<Attribute>> uriFragment2AttributesMap = new HashMap<String, List<Attribute>>();
        for (Attribute attribute : schedulerAttributes) {
            String uriFragment = attribute.getValue();
            if (!uriFragment2AttributesMap.containsKey(uriFragment)) {
                uriFragment2AttributesMap.put(uriFragment, new ArrayList());
            }
            ((List)uriFragment2AttributesMap.get(uriFragment)).add(attribute);
        }
        return uriFragment2AttributesMap;
    }

    protected void populateAllHREF_ElementAttributes_having_legacy_URI_refs(File targetFile, Document rootDocument, String xpath_elementtype_href_attribute, String HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES, Namespace ... namespaces) {
        List<Attribute> schedulerHrefs = HelperUtil.getXpathResult(rootDocument, xpath_elementtype_href_attribute, Attribute.class, namespaces);
        HashMap<String, File> refFileInfoMap = new HashMap<String, File>();
        HashMap reffile2uriFragment2schedulerRefAttribsMap = new HashMap();
        this.getCacheMap().get(targetFile).put(HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES, reffile2uriFragment2schedulerRefAttribsMap);
        for (Attribute attribute : schedulerHrefs) {
            String uriFragment_with_fileInfo = attribute.getValue();
            int indexOfHash = uriFragment_with_fileInfo.indexOf(35);
            if (indexOfHash == -1) continue;
            String fileNameInfo = uriFragment_with_fileInfo.substring(0, indexOfHash);
            String localURIFragment = uriFragment_with_fileInfo.substring(indexOfHash + 1);
            if (!localURIFragment.contains("//")) continue;
            File refFile = this.getRefFile(targetFile, refFileInfoMap, fileNameInfo);
            if (refFile != null) {
                this.addAttributeTo_Href_URIFragment_Attributes_Cache(targetFile, refFile, uriFragment_with_fileInfo, fileNameInfo, localURIFragment, attribute, HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES);
                continue;
            }
            LOGGER.error("Skipping attribut with value : {}", (Object)uriFragment_with_fileInfo);
        }
    }

    protected File getRefFile(File targetFile, HashMap<String, File> refFileInfoMap, String fileNameInfo) {
        File referredFile = null;
        if (!refFileInfoMap.containsKey(fileNameInfo)) {
            referredFile = new File(fileNameInfo);
            if (!referredFile.exists() && !(referredFile = new File(targetFile.getParent(), fileNameInfo)).exists()) {
                referredFile = null;
                LOGGER.error("Unable to find the referred file : {}", (Object)fileNameInfo);
            }
            refFileInfoMap.put(fileNameInfo, referredFile);
        } else {
            referredFile = refFileInfoMap.get(fileNameInfo);
        }
        return referredFile;
    }

    protected void populate_All_UUID_Elements(File targetFile, Document rootDocument, String xpath, String uuidElement, Namespace ... nameSpaces) {
        Map<String, Element> uuid2elementMap = null;
        if (!this.getCacheMap().get(targetFile).containsKey(uuidElement)) {
            uuid2elementMap = new HashMap();
            this.getCacheMap().get(targetFile).put(uuidElement, uuid2elementMap);
        } else {
            uuid2elementMap = (Map)this.getCacheMap().get(targetFile).get(uuidElement);
        }
        List<Element> elements = HelperUtil.getXpathResult(rootDocument, xpath, Element.class, nameSpaces);
        for (Element element : elements) {
            Attribute attribute = element.getAttribute("id", AmaltheaNamespaceRegistry.getGenericNamespace("xmi"));
            if (attribute == null) continue;
            uuid2elementMap.put(attribute.getValue(), element);
        }
    }

    protected void populate_All_Elements_With_Name(File targetFile, Document rootDocument, String xpath, String elementName, Namespace ... nameSpaces) {
        Map<String, Element> name2elementMap = null;
        if (!this.getCacheMap().get(targetFile).containsKey(elementName)) {
            name2elementMap = new HashMap();
            this.getCacheMap().get(targetFile).put(elementName, name2elementMap);
        } else {
            name2elementMap = (Map)this.getCacheMap().get(targetFile).get(elementName);
        }
        List<Element> elements = HelperUtil.getXpathResult(rootDocument, xpath, Element.class, nameSpaces);
        for (Element element : elements) {
            Attribute attribute = element.getAttribute("name");
            if (attribute == null) continue;
            name2elementMap.put(attribute.getValue(), element);
        }
    }

    protected void populate_AllElements_referred_by_hrefURIFragments(File targetFile, Document rootDocument, Map<File, Document> fileName2documentMap, String HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES, String HREF_URIFRAGMENT_ELEMENT) {
        Map reffile2uriFragment2schedulerRefAttribsMap = (Map)this.getCacheMap().get(targetFile).get(HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES);
        Set keySet = reffile2uriFragment2schedulerRefAttribsMap.keySet();
        HashMap<String, Element> allElements_referred_by_URIFragments = new HashMap<String, Element>();
        this.getCacheMap().get(targetFile).put(HREF_URIFRAGMENT_ELEMENT, allElements_referred_by_URIFragments);
        for (File referencedFile : keySet) {
            Document targetDocument = fileName2documentMap.get(referencedFile);
            Map table = (Map)reffile2uriFragment2schedulerRefAttribsMap.get(referencedFile);
            HashMap<String, String> localUriFragment2globalUriFragmentMap = new HashMap<String, String>();
            HashMap<String, String> localUriFragment2XpathMap = new HashMap<String, String>();
            Map<Object, Object> xpath2ElementsMap = new HashMap();
            for (Map.Entry entry : table.entrySet()) {
                String row_globalURI = (String)entry.getKey();
                Map rowMap = (Map)entry.getValue();
                Set columns = rowMap.keySet();
                if (columns == null || columns.isEmpty()) continue;
                for (String column_localURI : columns) {
                    localUriFragment2globalUriFragmentMap.put(column_localURI, row_globalURI);
                    localUriFragment2XpathMap.put(column_localURI, this.getXpathString(column_localURI));
                }
            }
            BulkXpathOperation bulkXpathOperation = new BulkXpathOperation();
            xpath2ElementsMap = bulkXpathOperation.invokeXpath(targetDocument, localUriFragment2XpathMap.values());
            for (Map.Entry entry : localUriFragment2XpathMap.entrySet()) {
                String localUri = (String)entry.getKey();
                String xpath = (String)entry.getValue();
                String globalUri = (String)localUriFragment2globalUriFragmentMap.get(localUri);
                List elements = (List)xpath2ElementsMap.get(xpath);
                if (!elements.isEmpty()) {
                    allElements_referred_by_URIFragments.put(globalUri, (Element)elements.get(0));
                    continue;
                }
                LOGGER.error("Element could not be found for URI : {}", (Object)globalUri);
            }
        }
    }
}

