/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ascape.adapt;

import org.ascape.model.Agent;
import org.ascape.model.AscapeObject;
import org.ascape.model.HostCell;
import org.ascape.model.event.ScapeListener;
import org.eclipse.amp.agf.GenericGraphicsProvider;
import org.eclipse.amp.escape.ascape.wrap.ScapeWrapperModelListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;

public class AscapeGraphicsProvider
extends GenericGraphicsProvider {
    private static AscapeGraphicsProvider singleton;

    public String getText(Object element) {
        String text = null;
        if (element.getClass() == HostCell.class) {
            return "Cell " + ((HostCell)element).getCoordinate();
        }
        if (element instanceof AscapeObject && (text = ((AscapeObject)element).getName()) != null) {
            return text;
        }
        if (element instanceof ScapeListener && (text = ((ScapeListener)element).getName()) != null) {
            return text;
        }
        if (element instanceof ScapeWrapperModelListener) {
            return this.getText(((ScapeWrapperModelListener)element).getWrapped());
        }
        return super.getText(element);
    }

    public Color getForeground(Object element) {
        if (element instanceof IColorProvider) {
            return ((IColorProvider)element).getForeground(element);
        }
        if (element instanceof Agent) {
            return (Color)((Agent)element).getPlatformColor();
        }
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof IColorProvider) {
            return ((IColorProvider)element).getBackground(element);
        }
        if (element instanceof Agent) {
            return (Color)((Agent)element).getPlatformColor();
        }
        return null;
    }

    public static AscapeGraphicsProvider getDefault() {
        if (singleton == null) {
            singleton = new AscapeGraphicsProvider();
        }
        return singleton;
    }

    public static /* bridge */ /* synthetic */ GenericGraphicsProvider getDefault() {
        return AscapeGraphicsProvider.getDefault();
    }
}

