/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.module.main;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.antlr.v4.runtime.Lexer;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.strategy.IWriterFactory;
import org.eclipse.acceleo.aql.ide.ui.AcceleoUIPlugin;
import org.eclipse.acceleo.aql.ide.ui.evaluation.strategy.AcceleoUIWorkspaceWriterFactory;
import org.eclipse.acceleo.aql.ide.ui.property.AcceleoPropertyTester;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.core.expressions.IPropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractGenerator {
    protected static final String MAVEN_INDENTATION = "    ";
    private final IPropertyTester propertyTester = new AcceleoPropertyTester();
    private IWriterFactory writeractory;
    private final Map<URI, String> preview = new LinkedHashMap<URI, String>();

    protected Set<String> getDependencyBundleNames(IQualifiedNameQueryEnvironment queryEnvironment, Module module) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        AstValidator validator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)queryEnvironment));
        for (Template main : AcceleoUtil.getMainTemplates((Module)module)) {
            for (Variable parameter : main.getParameters()) {
                IValidationResult validationResult = validator.validate(Collections.emptyMap(), parameter.getType());
                for (IType iType : validator.getDeclarationTypes((IReadOnlyQueryEnvironment)queryEnvironment, validationResult.getPossibleTypes(parameter.getType().getAst()))) {
                    Object type = iType.getType();
                    Class cls = type instanceof Class ? (Class)type : (type instanceof EClassifier && ((EClassifier)type).getInstanceClass() != null ? ((EClassifier)type).getInstanceClass() : null);
                    if (cls == null || !(cls.getClassLoader() instanceof BundleReference)) continue;
                    Bundle bundle = ((BundleReference)cls.getClassLoader()).getBundle();
                    res.add(bundle.getSymbolicName());
                }
            }
        }
        if (res.contains("org.eclipse.uml2.uml")) {
            res.add("org.eclipse.uml2.uml.resources");
        }
        return res;
    }

    protected void addPluginDependencies(IBundleModel model, Set<String> dependencyBundleNames) {
        IBundle bundle = model.getBundle();
        IManifestHeader manifestHeader = bundle.getManifestHeader("Require-Bundle");
        String requiredBundleString = manifestHeader != null ? manifestHeader.getValue() : null;
        if (requiredBundleString == null) {
            StringJoiner joiner = new StringJoiner(",\n  ");
            for (String dependency : dependencyBundleNames) {
                joiner.add(dependency);
            }
            bundle.setHeader("Require-Bundle", joiner.toString());
        } else {
            StringJoiner joiner = new StringJoiner(",\n  ");
            joiner.add(requiredBundleString);
            for (String dependency : dependencyBundleNames) {
                int lastSemiColonIndex = dependency.lastIndexOf(";");
                String dependencyBundleName = lastSemiColonIndex >= 0 ? dependency.substring(0, lastSemiColonIndex) : dependency;
                boolean foundInRequirement = false;
                String[] stringArray = requiredBundleString.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String requirement = stringArray[n2];
                    if (requirement.contains(dependencyBundleName)) {
                        foundInRequirement = true;
                        break;
                    }
                    ++n2;
                }
                if (!foundInRequirement) {
                    joiner.add(dependency);
                }
                bundle.setHeader("Require-Bundle", joiner.toString());
            }
        }
    }

    protected void addExportPackages(IBundleModel model, Set<String> packages) {
        IBundle bundle = model.getBundle();
        IManifestHeader manifestHeader = bundle.getManifestHeader("Export-Package");
        String exportedPackageString = manifestHeader != null ? manifestHeader.getValue() : null;
        if (exportedPackageString == null) {
            StringJoiner joiner = new StringJoiner(",\n  ");
            for (String dependency : packages) {
                joiner.add(dependency);
            }
            bundle.setHeader("Export-Package", joiner.toString());
        } else {
            StringJoiner joiner = new StringJoiner(",\n  ");
            joiner.add(exportedPackageString);
            for (String dependency : packages) {
                boolean foundInExportedPacakges = false;
                String[] stringArray = exportedPackageString.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String requirement = stringArray[n2];
                    if (requirement.contains(dependency)) {
                        foundInExportedPacakges = true;
                        break;
                    }
                    ++n2;
                }
                if (!foundInExportedPacakges) {
                    joiner.add(dependency);
                }
                bundle.setHeader("Export-Package", joiner.toString());
            }
        }
    }

    protected boolean isInPluginProject(IResource resource) {
        return this.propertyTester.test((Object)resource, "isInPluginProject", null, (Object)Boolean.TRUE);
    }

    protected boolean isInMavenProject(IResource resource) {
        return this.propertyTester.test((Object)resource, "isInMavenProject", null, (Object)Boolean.TRUE);
    }

    protected String getAcceleoVersionLowerBound() {
        Version version = AcceleoUIPlugin.getDefault().getBundle().getVersion();
        return new Version(version.getMajor(), version.getMinor(), version.getMicro()).toString();
    }

    protected String getAcceleoVersionUpperBound() {
        Version version = AcceleoUIPlugin.getDefault().getBundle().getVersion();
        return new Version(version.getMajor() + 1, 0, 0).toString();
    }

    protected String getAQLVersionLowerBound() {
        ClassLoader aqlClassloader = AQLUtils.class.getClassLoader();
        Version version = aqlClassloader instanceof BundleReference ? ((BundleReference)aqlClassloader).getBundle().getVersion() : new Version(8, 0, 0);
        return new Version(version.getMajor(), version.getMinor(), version.getMicro()).toString();
    }

    protected String getAQLVersionUpperBound() {
        ClassLoader aqlClassloader = AQLUtils.class.getClassLoader();
        Version version = aqlClassloader instanceof BundleReference ? ((BundleReference)aqlClassloader).getBundle().getVersion() : new Version(8, 0, 0);
        return new Version(version.getMajor() + 1, 0, 0).toString();
    }

    protected String getANTLRVersionLowerBound() {
        ClassLoader aqlClassloader = Lexer.class.getClassLoader();
        Version version = aqlClassloader instanceof BundleReference ? ((BundleReference)aqlClassloader).getBundle().getVersion() : new Version(4, 13, 2);
        return new Version(version.getMajor(), version.getMinor(), version.getMicro()).toString();
    }

    protected String getANTLRVersionUpperBound() {
        ClassLoader antlrClassloader = Lexer.class.getClassLoader();
        Version version = antlrClassloader instanceof BundleReference ? ((BundleReference)antlrClassloader).getBundle().getVersion() : new Version(4, 13, 1);
        return new Version(version.getMajor(), version.getMinor(), version.getMicro() + 1).toString();
    }

    protected IWriterFactory getWriterFactory() {
        if (this.writeractory == null) {
            this.writeractory = this.createWriterFactory();
        }
        return this.writeractory;
    }

    protected IWriterFactory createWriterFactory() {
        return new AcceleoUIWorkspaceWriterFactory(this.preview);
    }

    public Map<URI, String> getPreview() {
        Map<Object, Object> res = this.preview != null ? this.preview : Collections.emptyMap();
        return res;
    }

    protected boolean addMavenDependencies(Document pom, Element project, List<MavenDependency> dependencies) {
        Node dependenciesNode;
        boolean res = false;
        HashSet<String> knownDependencies = new HashSet<String>();
        NodeList dependenciesList = project.getElementsByTagName("dependencies");
        if (dependenciesList.getLength() > 0) {
            int i = 0;
            while (i < dependenciesList.getLength()) {
                NodeList artifactIds;
                Node currentDependencies = dependenciesList.item(i);
                if (currentDependencies instanceof Element && (artifactIds = ((Element)currentDependencies).getElementsByTagName("artifactId")) != null) {
                    int j = 0;
                    while (j < artifactIds.getLength()) {
                        knownDependencies.add(artifactIds.item(j).getTextContent());
                        ++j;
                    }
                }
                ++i;
            }
            dependenciesNode = dependenciesList.item(0);
        } else {
            dependenciesNode = pom.createElement("dependencies");
            project.appendChild(pom.createTextNode(System.lineSeparator() + MAVEN_INDENTATION));
            project.appendChild(dependenciesNode);
            dependenciesNode.appendChild(pom.createTextNode(System.lineSeparator() + MAVEN_INDENTATION));
            project.appendChild(pom.createTextNode(System.lineSeparator()));
        }
        for (MavenDependency dependency : dependencies) {
            if (knownDependencies.contains(dependency.getArtifactId())) continue;
            this.addMavenDependencyNode(pom, dependenciesNode, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            res = true;
        }
        return res;
    }

    protected void addMavenDependencyNode(Document pom, Node dependencies, String groupIdString, String artifactIdString, String versionString) {
        if (dependencies instanceof Element) {
            Element dependency = pom.createElement("dependency");
            dependencies.appendChild(pom.createTextNode(MAVEN_INDENTATION));
            dependencies.appendChild(dependency);
            dependencies.appendChild(pom.createTextNode(System.lineSeparator() + MAVEN_INDENTATION));
            Element groupId = pom.createElement("groupId");
            dependency.appendChild(pom.createTextNode(System.lineSeparator() + "            "));
            dependency.appendChild(groupId);
            groupId.setTextContent(groupIdString);
            Element artifactId = pom.createElement("artifactId");
            dependency.appendChild(pom.createTextNode(System.lineSeparator() + "            "));
            dependency.appendChild(artifactId);
            artifactId.setTextContent(artifactIdString);
            Element version = pom.createElement("version");
            dependency.appendChild(pom.createTextNode(System.lineSeparator() + "            "));
            dependency.appendChild(version);
            dependency.appendChild(pom.createTextNode(System.lineSeparator() + "        "));
            version.setTextContent(versionString);
        }
    }

    protected String getQualifiedNameFromSourceFile(IFile file) {
        String res = null;
        IPath filePath = file.getFullPath();
        IJavaProject project = JavaCore.create((IProject)file.getProject());
        try {
            IClasspathEntry[] iClasspathEntryArray = project.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    IPath entryPath = entry.getPath();
                    IPath relativePath = filePath.makeRelativeTo(entryPath);
                    if (!filePath.toString().equals(relativePath.toString())) {
                        res = relativePath.toString().substring(0, relativePath.toString().length() - relativePath.getFileExtension().length() - 1).replace("/", "::");
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, this.getClass(), "can't get qualified name for " + String.valueOf(file.getFullPath()), (Throwable)e));
        }
        return res;
    }

    protected Module loadModelModule(URI moduleURI, String qualifiedName) {
        Module res;
        AcceleoParser parser = new AcceleoParser();
        try {
            String encoding;
            InputStream is;
            Throwable throwable = null;
            Object var7_7 = null;
            try {
                is = URIConverter.INSTANCE.createInputStream(moduleURI);
                try {
                    encoding = parser.parseEncoding(is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var7_7 = null;
            try {
                is = URIConverter.INSTANCE.createInputStream(moduleURI);
                try {
                    res = is != null ? parser.parse(is, encoding, qualifiedName).getModule() : null;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, this.getClass(), "can't load model module " + String.valueOf(moduleURI), (Throwable)e));
            res = null;
        }
        return res;
    }

    protected static class MavenDependency {
        private final String groupId;
        private final String artifactId;
        private final String version;

        MavenDependency(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

