/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.folding;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerLifecycle;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.DocumentUtil;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class LSPFoldingReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IProjectionListener,
ITextViewerLifecycle {
    private @Nullable IDocument document;
    private @Nullable ProjectionAnnotationModel projectionAnnotationModel;
    private @Nullable ProjectionViewer viewer;
    private List<CompletableFuture<@Nullable List<FoldingRange>>> requests = List.of();
    private volatile long timestamp = 0L;
    private final boolean collapseImports;

    public LSPFoldingReconcilingStrategy() {
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        this.collapseImports = store.getBoolean("foldingReconcilingStrategy.collapseImports");
    }

    public void reconcile(@Nullable IRegion subRegion) {
        IDocument document = this.document;
        if (this.projectionAnnotationModel == null || document == null) {
            return;
        }
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return;
        }
        TextDocumentIdentifier identifier = LSPEclipseUtils.toTextDocumentIdentifier(uri);
        FoldingRangeRequestParams params = new FoldingRangeRequestParams(identifier);
        this.requests.forEach(request -> {
            boolean bl = request.cancel(true);
        });
        this.requests = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getFoldingRangeProvider)).computeAll(server -> server.getTextDocumentService().foldingRange(params));
        this.requests.forEach(ranges -> {
            CompletionStage completionStage = ranges.thenAccept(this::applyFolding);
        });
    }

    private void applyFolding(@Nullable List<FoldingRange> ranges) {
        ProjectionAnnotationModel theProjectionAnnotationModel;
        ArrayList<FoldingAnnotation> deletions = new ArrayList<FoldingAnnotation>();
        ArrayList<FoldingAnnotation> existing = new ArrayList<FoldingAnnotation>();
        HashMap<Annotation, Position> additions = new HashMap<Annotation, Position>();
        this.markInvalidAnnotationsForDeletion(deletions, existing);
        try {
            if (ranges != null) {
                Collections.sort(ranges, Comparator.comparing(FoldingRange::getEndLine));
                for (FoldingRange foldingRange : ranges) {
                    this.updateAnnotation(deletions, existing, additions, foldingRange.getStartLine(), foldingRange.getEndLine(), this.collapseImports && "imports".equals(foldingRange.getKind()));
                }
            }
        }
        catch (BadLocationException foldingRange) {
            // empty catch block
        }
        if ((theProjectionAnnotationModel = this.projectionAnnotationModel) != null) {
            if (!existing.isEmpty()) {
                deletions.addAll(existing);
            }
            theProjectionAnnotationModel.modifyAnnotations((Annotation[])deletions.toArray(Annotation[]::new), additions, new Annotation[0]);
        }
    }

    public void install(ITextViewer viewer) {
        if (this.viewer != null) {
            this.viewer.removeProjectionListener((IProjectionListener)this);
        }
        if (viewer instanceof ProjectionViewer) {
            ProjectionViewer projViewer;
            this.viewer = projViewer = (ProjectionViewer)viewer;
            projViewer.addProjectionListener((IProjectionListener)this);
            this.projectionAnnotationModel = projViewer.getProjectionAnnotationModel();
        }
    }

    public void uninstall() {
        this.setDocument(null);
        if (this.viewer != null) {
            this.viewer.removeProjectionListener((IProjectionListener)this);
            this.viewer = null;
        }
        this.projectionDisabled();
    }

    public void setDocument(@Nullable IDocument document) {
        this.document = document;
    }

    public void projectionDisabled() {
        this.projectionAnnotationModel = null;
    }

    public void projectionEnabled() {
        ProjectionViewer theViewer = this.viewer;
        if (theViewer != null) {
            this.projectionAnnotationModel = theViewer.getProjectionAnnotationModel();
        }
    }

    private void updateAnnotation(List<FoldingAnnotation> deletions, List<FoldingAnnotation> existing, Map<Annotation, Position> additions, int line, Integer endLineNumber, boolean collapsedByDefault) throws BadLocationException {
        IDocument document = NullSafetyHelper.castNonNull(this.document);
        int startOffset = document.getLineOffset(line);
        int endOffset = document.getLineOffset(endLineNumber.intValue()) + document.getLineLength(endLineNumber.intValue());
        Position newPos = new Position(startOffset, endOffset - startOffset);
        if (!existing.isEmpty()) {
            FoldingAnnotation existingAnnotation = existing.remove(existing.size() - 1);
            this.updateAnnotations((Annotation)existingAnnotation, newPos, deletions);
        } else {
            additions.put((Annotation)new FoldingAnnotation(collapsedByDefault), newPos);
        }
    }

    protected void updateAnnotations(Annotation existingAnnotation, @Nullable Position newPos, List<FoldingAnnotation> deletions) {
        if (existingAnnotation instanceof FoldingAnnotation) {
            FoldingAnnotation foldingAnnotation = (FoldingAnnotation)existingAnnotation;
            ProjectionAnnotationModel theProjectionAnnotationModel = this.projectionAnnotationModel;
            if (newPos != null && newPos.length > 0 && theProjectionAnnotationModel != null) {
                Position oldPos = theProjectionAnnotationModel.getPosition((Annotation)foldingAnnotation);
                if (!newPos.equals((Object)oldPos)) {
                    theProjectionAnnotationModel.modifyAnnotationPosition((Annotation)foldingAnnotation, newPos);
                }
            } else {
                deletions.add(foldingAnnotation);
            }
        }
    }

    protected void markInvalidAnnotationsForDeletion(List<FoldingAnnotation> deletions, List<FoldingAnnotation> existing) {
        ProjectionAnnotationModel projectionAnnotationModel = this.projectionAnnotationModel;
        if (projectionAnnotationModel == null) {
            return;
        }
        Iterator iter = projectionAnnotationModel.getAnnotationIterator();
        if (iter != null) {
            while (iter.hasNext()) {
                Object e = iter.next();
                if (!(e instanceof FoldingAnnotation)) continue;
                FoldingAnnotation foldingAnno = (FoldingAnnotation)((Object)e);
                Position pos = projectionAnnotationModel.getPosition((Annotation)foldingAnno);
                if (pos.length == 0) {
                    deletions.add(foldingAnno);
                    continue;
                }
                existing.add(foldingAnno);
            }
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion partition) {
        long ts = DocumentUtil.getDocumentModificationStamp(this.document);
        if (ts != this.timestamp) {
            this.reconcile((IRegion)dirtyRegion);
            this.timestamp = ts;
        }
    }

    public void setProgressMonitor(@Nullable IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        this.reconcile(null);
    }

    protected class FoldingAnnotation
    extends ProjectionAnnotation {
        private boolean visible;

        public FoldingAnnotation(boolean isCollapsed) {
            super(isCollapsed);
            this.visible = false;
        }

        public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
            FontMetrics metrics;
            if (!this.isCollapsed() && (metrics = gc.getFontMetrics()) != null && rectangle.height / metrics.getHeight() <= 1) {
                this.visible = false;
                return;
            }
            this.visible = true;
            super.paint(gc, canvas, rectangle);
        }

        public void markCollapsed() {
            if (this.visible) {
                super.markCollapsed();
            }
        }
    }
}

