/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.snippets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.ui.internal.snippets.Snippet;
import org.eclipse.tm4e.ui.snippets.ISnippet;
import org.eclipse.tm4e.ui.snippets.ISnippetManager;

public final class SnippetManager
implements ISnippetManager {
    private static final ISnippet[] EMPTY_SNIPPETS = new ISnippet[0];
    private static final String SNIPPET_ELT = "snippet";
    private static final String EXTENSION_SNIPPETS = "snippets";
    private final Map<String, List<ISnippet>> snippets = new HashMap<String, List<ISnippet>>();

    public static ISnippetManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private SnippetManager() {
    }

    private void load() {
        this.loadGrammarsFromExtensionPoints();
    }

    private void loadGrammarsFromExtensionPoints() {
        IConfigurationElement[] cf;
        IConfigurationElement[] iConfigurationElementArray = cf = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tm4e.ui", EXTENSION_SNIPPETS);
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String extensionName = ce.getName();
            if (SNIPPET_ELT.equals(extensionName)) {
                this.registerSnippet(new Snippet(ce));
            }
            ++n2;
        }
    }

    private void registerSnippet(Snippet snippet) {
        String scopeName = snippet.getScopeName();
        this.snippets.computeIfAbsent(scopeName, scopeName_ -> new ArrayList()).add(snippet);
    }

    @Override
    public ISnippet[] getSnippets(String scopeName) {
        List snippets = (List)NullSafetyHelper.castNullable(this.snippets.get(scopeName));
        return snippets != null ? (ISnippet[])snippets.toArray(ISnippet[]::new) : EMPTY_SNIPPETS;
    }

    private static final class InstanceHolder {
        static final SnippetManager INSTANCE = new SnippetManager();

        static {
            INSTANCE.load();
        }

        private InstanceHolder() {
        }
    }
}

