/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hierarchical;

import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalWrapper;
import org.eclipse.nebula.widgets.nattable.layer.cell.DataCell;

public class HierarchicalSpanningDataProvider
implements ISpanningDataProvider {
    private final IRowDataProvider<HierarchicalWrapper> underlyingDataProvider;
    private final List<String> propertyNames;

    public HierarchicalSpanningDataProvider(IRowDataProvider<HierarchicalWrapper> underlyingDataProvider, String ... propertyNames) {
        this(underlyingDataProvider, Arrays.asList(propertyNames));
    }

    public HierarchicalSpanningDataProvider(IRowDataProvider<HierarchicalWrapper> underlyingDataProvider, List<String> propertyNames) {
        this.underlyingDataProvider = underlyingDataProvider;
        this.propertyNames = propertyNames;
    }

    @Override
    public Object getDataValue(int columnIndex, int rowIndex) {
        return this.underlyingDataProvider.getDataValue(columnIndex, rowIndex);
    }

    @Override
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        this.underlyingDataProvider.setDataValue(columnIndex, rowIndex, newValue);
    }

    @Override
    public int getColumnCount() {
        return this.underlyingDataProvider.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.underlyingDataProvider.getRowCount();
    }

    @Override
    public DataCell getCellByPosition(int columnPosition, int rowPosition) {
        String propertyName = this.propertyNames.get(columnPosition);
        int level = propertyName.split("\\.").length - 1;
        int cellRowPosition = this.getStartRowPosition(rowPosition, level);
        int rowSpan = this.getRowSpan(cellRowPosition, level);
        return new DataCell(columnPosition, cellRowPosition, 1, rowSpan);
    }

    protected int getStartRowPosition(int rowPosition, int level) {
        int rowPos = rowPosition;
        while (rowPos >= 0) {
            Object before;
            Object current;
            if (rowPos <= 0 || !this.valuesEqual(current = this.getLevelObject(rowPos, level), before = this.getLevelObject(rowPos - 1, level))) break;
            --rowPos;
        }
        return rowPos;
    }

    protected int getRowSpan(int rowPosition, int level) {
        int span = 1;
        while (rowPosition < this.getRowCount() - 1 && this.valuesEqual(this.getLevelObject(rowPosition, level), this.getLevelObject(rowPosition + 1, level))) {
            ++span;
            ++rowPosition;
        }
        return span;
    }

    protected Object getLevelObject(int rowPosition, int level) {
        HierarchicalWrapper hierarchical = this.underlyingDataProvider.getRowObject(rowPosition);
        return hierarchical.getObject(level);
    }

    protected boolean valuesEqual(Object value1, Object value2) {
        return value1 != null && value2 != null && value1 == value2;
    }
}

