/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget.nattable;

import java.lang.invoke.StringConcatFactory;
import org.eclipse.draw2d.colors.HSL;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

final class FordiacNatTableConfiguration
extends ModernNatTableThemeConfiguration {
    public FordiacNatTableConfiguration() {
        ColorRegistry colorRegistry = FordiacNatTableConfiguration.getCurrentTheme().getColorRegistry();
        this.defaultBgColor = colorRegistry.get("org.eclipse.fordiac.ide.ui.NatTableDefaultBackground");
        this.defaultFgColor = colorRegistry.get("org.eclipse.gef.color.list.foreground");
        this.cHeaderBgColor = colorRegistry.get("org.eclipse.gef.color.button");
        this.cHeaderFgColor = colorRegistry.get("org.eclipse.gef.color.menu.foreground");
        this.rHeaderBgColor = this.cHeaderBgColor;
        this.rHeaderFgColor = this.cHeaderFgColor;
        this.cHeaderSelectionBgColor = this.cHeaderBgColor;
        this.cHeaderSelectionFgColor = this.cHeaderFgColor;
        this.rHeaderSelectionBgColor = this.cHeaderBgColor;
        this.rHeaderSelectionFgColor = this.cHeaderFgColor;
        this.selectionAnchorSelectionBgColor = this.cHeaderBgColor;
        this.selectionAnchorSelectionFgColor = this.cHeaderFgColor;
        this.selectionAnchorBgColor = this.cHeaderBgColor;
        this.selectionAnchorFgColor = this.cHeaderFgColor;
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        super.configureRegistry(configRegistry);
        this.configureErrorCells(configRegistry);
        this.configureWarningCells(configRegistry);
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.LEFT);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "LEFT_ALIGNMENT");
        this.configureDisabledCells(configRegistry);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new BackgroundPainter((ICellPainter)new PaddingDecorator((ICellPainter)new TextPainter(false, true, false, true), 2, 2, 2, 2)));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new BackgroundPainter((ICellPainter)new PaddingDecorator((ICellPainter)new LeftTruncatingTextPainter(), 2, 2, 2, 2)), DisplayMode.NORMAL, "LEFT_TRUNCATING");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)GUIHelper.COLOR_DARK_GRAY);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "DEFAULT_CELL");
        configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "selectionAnchor");
    }

    private void configureErrorCells(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_RED);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "ERROR_CELL");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)new Color(255, 100, 100));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, "ERROR_CELL");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.defaultBgColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.EDIT, "ERROR_CELL");
    }

    private void configureWarningCells(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_YELLOW);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "WARNING_CELL");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.getColor((int)255, (int)255, (int)100));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, "WARNING_CELL");
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.defaultBgColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.EDIT, "WARNING_CELL");
    }

    private void configureDisabledCells(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)this.cHeaderBgColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "DISABLED_CELL");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "DISABLED_HEADER");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECT, "DISABLED_HEADER");
    }

    public void createPainterInstances() {
        super.createPainterInstances();
        if (HSL.fromColor((Color)this.defaultBgColor).isDark()) {
            this.treeStructurePainter = this.treeStructureSelectionPainter;
        }
    }

    protected IStyle getColumnHeaderStyle() {
        IStyle style = super.getColumnHeaderStyle();
        style.setAttributeValue(CellStyleAttributes.FONT, (Object)FordiacNatTableConfiguration.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        return style;
    }

    protected IStyle getColumnHeaderSelectionStyle() {
        IStyle style = super.getColumnHeaderSelectionStyle();
        style.setAttributeValue(CellStyleAttributes.FONT, (Object)FordiacNatTableConfiguration.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        return style;
    }

    private static FontRegistry getFontRegistry() {
        return FordiacNatTableConfiguration.getCurrentTheme().getFontRegistry();
    }

    private static ITheme getCurrentTheme() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
    }

    private static class LeftTruncatingTextPainter
    extends TextPainter {
        public LeftTruncatingTextPainter() {
            super(false, true, false, true);
        }

        protected String getTextToDisplay(ILayerCell cell, GC gc, int availableLength, String text) {
            if (text == null || text.isEmpty()) {
                return "";
            }
            String dots = "...";
            if (gc.textExtent((String)text).x <= availableLength) {
                return text;
            }
            StringBuilder result = new StringBuilder();
            int i = text.length() - 1;
            while (i >= 0) {
                result.insert(0, text.charAt(i));
                int currentWidth = gc.textExtent((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"...\u0001"}, (String)result.toString()))).x;
                if (currentWidth > availableLength) {
                    return "..." + result.substring(1);
                }
                --i;
            }
            return "..." + result.toString();
        }
    }
}

